/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.graphql.v8;

import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStrategyParameters;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class GraphqlInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        ExecutionStrategyParameters parameters = (ExecutionStrategyParameters)allArguments[1];
        if (parameters == null) {
            return;
        }
        ExecutionPath path = parameters.getPath();
        try {
            Field field = ExecutionPath.class.getDeclaredField("parent");
            field.setAccessible(true);
            ExecutionPath parentPath = (ExecutionPath)field.get(path);
            if (parentPath != ExecutionPath.rootPath()) {
                return;
            }
            AbstractSpan span = ContextManager.createLocalSpan((String)((graphql.language.Field)parameters.getField().get(0)).getName());
            Tags.LOGIC_ENDPOINT.set(span, "{\"logic-span\":true}");
            span.setComponent((Component)ComponentsDefine.GRAPHQL);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ExecutionStrategyParameters parameters = (ExecutionStrategyParameters)allArguments[1];
        if (parameters == null) {
            return ret;
        }
        ExecutionPath path = parameters.getPath();
        try {
            Field field = ExecutionPath.class.getDeclaredField("parent");
            field.setAccessible(true);
            ExecutionPath parentPath = (ExecutionPath)field.get(path);
            if (!parentPath.equals((Object)ExecutionPath.rootPath())) {
                return ret;
            }
            ContextManager.stopSpan();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ExecutionStrategyParameters parameters = (ExecutionStrategyParameters)allArguments[1];
        if (parameters == null) {
            return;
        }
        ExecutionPath path = parameters.getPath();
        try {
            Field field = ExecutionPath.class.getDeclaredField("parent");
            field.setAccessible(true);
            ExecutionPath parentPath = (ExecutionPath)field.get(path);
            if (!parentPath.equals((Object)ExecutionPath.rootPath())) {
                return;
            }
            this.dealException(t);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    private void dealException(Throwable throwable) {
        AbstractSpan span = ContextManager.activeSpan();
        span.log(throwable);
    }
}

