/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.prometheus.rule;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.Rule;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Rules {
    private static final Logger LOG = LoggerFactory.getLogger(Rule.class);

    public static List<Rule> loadRules(String path) throws IOException {
        return Rules.loadRules(path, Collections.emptyList());
    }

    public static List<Rule> loadRules(String path, List<String> enabledRules) throws IOException {
        List<Rule> rules;
        Path root = ResourceUtils.getPath((String)path);
        Map<String, Boolean> formedEnabledRules = enabledRules.stream().map(rule -> {
            if ((rule = rule.trim()).startsWith("/")) {
                rule = rule.substring(1);
            }
            if (!rule.endsWith(".yaml") && !rule.endsWith(".yml")) {
                return rule + "{.yaml,.yml}";
            }
            return rule;
        }).collect(Collectors.toMap(rule -> rule, $ -> false));
        try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);){
            rules = stream.filter(it -> formedEnabledRules.keySet().stream().anyMatch(rule -> {
                boolean matches = FileSystems.getDefault().getPathMatcher("glob:" + rule).matches(root.relativize((Path)it));
                if (matches) {
                    formedEnabledRules.put((String)rule, true);
                }
                return matches;
            })).map(pathPointer -> {
                String relativizePath = root.relativize((Path)pathPointer).toString();
                String ruleName = relativizePath.substring(0, relativizePath.lastIndexOf("."));
                return Rules.getRulesFromFile(ruleName, pathPointer);
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (formedEnabledRules.containsValue(false)) {
            List rulesNotFound = formedEnabledRules.keySet().stream().filter(rule -> (Boolean)formedEnabledRules.get(rule) == false).collect(Collectors.toList());
            throw new UnexpectedException("Some configuration files of enabled rules are not found, enabled rules: " + String.valueOf(rulesNotFound));
        }
        return rules;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Rule getRulesFromFile(String ruleName, Path path) {
        File file = path.toFile();
        if (!file.isFile()) return null;
        if (file.isHidden()) {
            return null;
        }
        try (FileReader r = new FileReader(file);){
            Rule rule = (Rule)new Yaml().loadAs((Reader)r, Rule.class);
            if (rule == null) {
                Rule rule2 = null;
                return rule2;
            }
            rule.setName(ruleName);
            Rule rule3 = rule;
            return rule3;
        }
        catch (IOException e) {
            throw new UnexpectedException("Load rule file" + file.getName() + " failed", (Exception)e);
        }
    }
}

