/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.internal.shaded.guava.escape.Escaper;
import com.linecorp.armeria.internal.shaded.guava.html.HtmlEscapers;
import com.linecorp.armeria.internal.shaded.guava.net.UrlEscapers;
import java.util.List;

final class AutoIndex {
    private static final String PART1 = "<!DOCTYPE html>\n<html><head><meta charset=\"UTF-8\"><title>Directory listing: ";
    private static final String PART2 = "</title><style>body { font-family: sans-serif; }.container { display: flex; }.directory-listing { margin: 0 auto; min-width: 60%; }.directory-listing ul { padding-left: 1.75em; }</style></head><body>\n<div class=\"container\"><div class=\"directory-listing\"><h1>Directory listing: ";
    private static final String PART3 = "</h1>\n<p>";
    private static final String PART4 = " file(s) total\n<ul>\n";
    private static final String PART5 = "</ul></p></div></div></body>\n</html>\n";

    static HttpData listingToHtml(String dirPath, String mappedDirPath, List<String> listing) {
        Escaper htmlEscaper = HtmlEscapers.htmlEscaper();
        Escaper urlEscaper = UrlEscapers.urlFragmentEscaper();
        String escapedDirPath = htmlEscaper.escape(dirPath);
        StringBuilder buf = new StringBuilder(listing.size() * 64);
        buf.append(PART1);
        buf.append(escapedDirPath);
        buf.append(PART2);
        buf.append(escapedDirPath);
        buf.append(PART3);
        buf.append(listing.size());
        buf.append(PART4);
        if (!"/".equals(mappedDirPath)) {
            buf.append("<li class=\"directory parent\"><a href=\"../\">../</a></li>\n");
        }
        for (String name : listing) {
            buf.append("<li class=\"");
            if (name.charAt(name.length() - 1) == '/') {
                buf.append("directory");
            } else {
                buf.append("file");
            }
            buf.append("\"><a href=\"");
            buf.append(urlEscaper.escape(name));
            buf.append("\">");
            buf.append(name);
            buf.append("</a></li>\n");
        }
        buf.append(PART5);
        return HttpData.ofUtf8(buf.toString());
    }

    private AutoIndex() {
    }
}

