/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.schedule;

import com.ctrip.framework.apollo.core.schedule.SchedulePolicy;

public class ExponentialSchedulePolicy
implements SchedulePolicy {
    private final long delayTimeLowerBound;
    private final long delayTimeUpperBound;
    private long lastDelayTime;

    public ExponentialSchedulePolicy(long delayTimeLowerBound, long delayTimeUpperBound) {
        this.delayTimeLowerBound = delayTimeLowerBound;
        this.delayTimeUpperBound = delayTimeUpperBound;
    }

    @Override
    public long fail() {
        long delayTime = this.lastDelayTime;
        delayTime = delayTime == 0L ? this.delayTimeLowerBound : Math.min(this.lastDelayTime << 1, this.delayTimeUpperBound);
        this.lastDelayTime = delayTime;
        return delayTime;
    }

    @Override
    public void success() {
        this.lastDelayTime = 0L;
    }
}

