/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc;

import com.google.rpc.Status;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.grpc.MetadataUtil;
import io.grpc.Metadata;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.Objects;

final class GoogleGrpcExceptionHandlerFunctionUtil {
    @Nullable
    static io.grpc.Status handleException(RequestContext ctx, Throwable throwable, Metadata metadata, StatusProtoHandler handler) {
        Throwable cause = Exceptions.peel((Throwable)Objects.requireNonNull(throwable, "throwable"));
        if (cause instanceof StatusRuntimeException) {
            return ((StatusRuntimeException)cause).getStatus();
        }
        if (cause instanceof StatusException) {
            return ((StatusException)cause).getStatus();
        }
        Status statusProto = handler.applyStatusProto(ctx, cause, metadata);
        if (statusProto == null) {
            return null;
        }
        io.grpc.Status status = io.grpc.Status.fromCodeValue((int)statusProto.getCode()).withDescription(statusProto.getMessage());
        metadata.discardAll(MetadataUtil.GRPC_STATUS_DETAILS_BIN_KEY);
        metadata.put(MetadataUtil.GRPC_STATUS_DETAILS_BIN_KEY, (Object)statusProto);
        return status;
    }

    private GoogleGrpcExceptionHandlerFunctionUtil() {
    }

    @FunctionalInterface
    static interface StatusProtoHandler {
        public @Nullable Status applyStatusProto(RequestContext var1, Throwable var2, Metadata var3);
    }
}

