/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.common.util.DomainSocketUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Objects;

@UnstableApi
public final class DomainSocketAddress
extends InetSocketAddress {
    private static final long serialVersionUID = 41779966264274119L;
    private final String path;
    @Nullable
    private String authority;
    @Nullable
    private Endpoint endpoint;
    @Nullable
    private io.netty.channel.unix.DomainSocketAddress nettyAddress;

    public static DomainSocketAddress of(Path path) {
        return DomainSocketAddress.of(Objects.requireNonNull(path, "path").toString());
    }

    public static DomainSocketAddress of(String path) {
        Objects.requireNonNull(path, "path");
        Preconditions.checkArgument(!path.isEmpty(), "path must not be empty.");
        return new DomainSocketAddress(path);
    }

    public static DomainSocketAddress of(io.netty.channel.unix.DomainSocketAddress nettyAddr) {
        String path = Objects.requireNonNull(nettyAddr, "nettyAddr").path();
        Preconditions.checkArgument(!path.isEmpty(), "nettyAddr.path must not be empty.");
        return new DomainSocketAddress(path);
    }

    public static boolean isDomainSocketAddress(InetAddress addr) {
        Objects.requireNonNull(addr, "addr");
        return DomainSocketUtil.isDomainSocketAddress(addr);
    }

    private DomainSocketAddress(String path) {
        super(DomainSocketUtil.toInetAddress(Objects.requireNonNull(path, "path")), 1);
        this.path = path;
    }

    public String path() {
        return this.path;
    }

    public boolean isAbstract() {
        return this.path.charAt(0) == '\u0000';
    }

    public String authority() {
        String newAuthority;
        String authority = this.authority;
        if (authority != null) {
            return authority;
        }
        this.authority = newAuthority = DomainSocketUtil.toAuthority(this.path);
        return newAuthority;
    }

    public io.netty.channel.unix.DomainSocketAddress asNettyAddress() {
        io.netty.channel.unix.DomainSocketAddress newNettyAddress;
        io.netty.channel.unix.DomainSocketAddress nettyAddress = this.nettyAddress;
        if (nettyAddress != null) {
            return nettyAddress;
        }
        this.nettyAddress = newNettyAddress = new io.netty.channel.unix.DomainSocketAddress(this.path);
        return newNettyAddress;
    }

    public Endpoint asEndpoint() {
        Endpoint newEndpoint;
        Endpoint endpoint = this.endpoint;
        if (endpoint != null) {
            return endpoint;
        }
        this.endpoint = newEndpoint = Endpoint.of(this.authority());
        return newEndpoint;
    }

    @Override
    public String toString() {
        if (this.isAbstract()) {
            return this.path.replace('\u0000', '@');
        }
        return this.path;
    }
}

