/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Arrays;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.storage.aggregate.GridSlice;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

final class GridSliceLocator {
    final GridSlice[] slices;
    final GridGeometry gridGeometry;
    final int searchDimension;
    private final long[] sliceLows;
    private final long[] sliceHighs;

    GridSliceLocator(GridGeometry domain, GridSlice[] selected, int searchDimension) {
        int i;
        this.searchDimension = searchDimension;
        this.slices = selected;
        this.sliceLows = new long[selected.length];
        this.sliceHighs = new long[selected.length];
        GridExtent aoi = domain.getExtent();
        int dimension = aoi.getDimension();
        DimensionNameType[] axes = new DimensionNameType[dimension];
        long[] low = new long[dimension];
        long[] high = new long[dimension];
        for (i = 0; i < dimension; ++i) {
            axes[i] = aoi.getAxisType(i).orElse(null);
            low[i] = Long.MAX_VALUE;
            high[i] = Long.MIN_VALUE;
        }
        for (i = 0; i < this.slices.length; ++i) {
            GridSlice slice = this.slices[i];
            GridExtent extent = slice.extentInGroup;
            this.sliceLows[i] = extent.getLow(searchDimension);
            this.sliceHighs[i] = extent.getHigh(searchDimension);
            for (int j = 0; j < dimension; ++j) {
                low[j] = Math.min(low[j], extent.getLow(j));
                high[j] = Math.max(high[j], extent.getHigh(j));
            }
        }
        if (!aoi.equals((Object)(aoi = new GridExtent(axes, low, high, true)))) {
            CoordinateReferenceSystem crs = domain.isDefined(1) ? domain.getCoordinateReferenceSystem() : null;
            domain = new GridGeometry(aoi, GridSlice.CELL_ANCHOR, domain.getGridToCRS(GridSlice.CELL_ANCHOR), crs);
        }
        this.gridGeometry = domain;
    }

    final int[] find(GridExtent request) {
        int lower;
        long high = request.getHigh(this.searchDimension);
        int upper = Arrays.binarySearch(this.sliceLows, high);
        if (upper < 0) {
            lower = upper ^= 0xFFFFFFFF;
        } else {
            lower = upper;
            while (++upper < this.sliceLows.length && this.sliceLows[upper] <= high) {
            }
        }
        long low = request.getLow(this.searchDimension);
        lower = Arrays.binarySearch(this.sliceHighs, 0, lower, low);
        if (lower < 0) {
            lower ^= 0xFFFFFFFF;
        } else {
            while (--lower >= 0 && this.sliceHighs[lower] >= low) {
            }
            ++lower;
        }
        int count = 0;
        int[] selection = new int[upper - lower];
        for (int i = lower; i < upper; ++i) {
            GridSlice slice = this.slices[i];
            if (!request.intersects(slice.extentInGroup)) continue;
            selection[count++] = i;
        }
        return ArraysExt.resize((int[])selection, (int)count);
    }

    final String getDimensionName(GridExtent extent) {
        return extent.getAxisType(this.searchDimension).map(Types::getCodeTitle).map(InternationalString::toString).orElseGet(() -> String.valueOf(this.searchDimension));
    }
}

