/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.transformer.request.template;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AiRequestTransformerTemplate {
    public static final String SYS_CONTENT = "You are an expert in HTTP/1.1 protocol. Your response should contain only standard HTTP/1.1 message content.  \nPlease return a complete HTTP/1.1 request or response message, including:  \n- Start line  \n- Multiple headers (one header per line, format: Header-Name: Header-Value)  \n- A blank line  \n- A JSON-formatted body (the body must be valid JSON text)  \nDo not include any extra explanations, comments, or text.  \nExample:\n\nHTTP/1.1 200 OK\nContent-Type: application/json\nAuthorization: Bearer xxx\n\n{\"name\":\"Alice\",\"age\":30}";
    private String userContent;
    private ServerHttpRequest originalRequest;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public AiRequestTransformerTemplate(String userContent, ServerHttpRequest originalRequest) {
        this.userContent = userContent;
        this.originalRequest = originalRequest;
    }

    private JsonNode headersToJson(HttpHeaders headers) {
        ObjectNode headersNode = this.objectMapper.createObjectNode();
        for (Map.Entry entry : headers.entrySet()) {
            String joinedValues = String.join((CharSequence)",", (Iterable)entry.getValue());
            headersNode.put((String)entry.getKey(), joinedValues);
        }
        return headersNode;
    }

    private Mono<String> bodyToString(Flux<DataBuffer> body) {
        return DataBufferUtils.join(body).map(dataBuffer -> {
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            DataBufferUtils.release((DataBuffer)dataBuffer);
            return new String(bytes, StandardCharsets.UTF_8);
        }).defaultIfEmpty((Object)"");
    }

    private Map<String, String> parseFormUrlEncoded(String body) {
        if (Objects.isNull(body) || body.isEmpty()) {
            return Map.of();
        }
        return Arrays.stream(body.split("&")).map(kv -> kv.split("=", 2)).filter(arr -> ((String[])arr).length == 2).collect(Collectors.toMap(arr -> this.urlDecode(arr[0]), arr -> this.urlDecode(arr[1]), (v1, v2) -> v2, LinkedHashMap::new));
    }

    private String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            return s;
        }
    }

    public Mono<String> assembleMessage() {
        JsonNode headersJson = this.headersToJson(this.originalRequest.getHeaders());
        MediaType contentType = this.originalRequest.getHeaders().getContentType();
        return this.bodyToString((Flux<DataBuffer>)this.originalRequest.getBody()).flatMap(bodyString -> {
            ObjectNode rootNode = this.objectMapper.createObjectNode();
            rootNode.put("system_prompt", SYS_CONTENT);
            rootNode.put("user_prompt", this.userContent);
            ObjectNode requestNode = this.objectMapper.createObjectNode();
            requestNode.set("headers", headersJson);
            if (Objects.nonNull(contentType)) {
                if (MediaType.APPLICATION_JSON.isCompatibleWith(contentType)) {
                    try {
                        JsonNode bodyJsonNode = this.objectMapper.readTree(bodyString);
                        requestNode.set("body", bodyJsonNode);
                    }
                    catch (Exception e) {
                        requestNode.put("body", bodyString);
                    }
                } else if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(contentType)) {
                    Map<String, String> formMap = this.parseFormUrlEncoded((String)bodyString);
                    JsonNode formJson = this.objectMapper.valueToTree(formMap);
                    requestNode.set("body", formJson);
                } else {
                    requestNode.put("body", bodyString);
                }
            } else {
                requestNode.put("body", bodyString);
            }
            rootNode.set("request", (JsonNode)requestNode);
            try {
                String jsonString = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
                return Mono.just((Object)jsonString);
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        });
    }
}

