/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.pojo;

import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.InstanceLocalValue;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.pojo.DefaultInstanceLocalValue;
import com.tencent.polaris.client.pojo.InstanceByProto;
import com.tencent.polaris.client.pojo.Node;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;
import com.tencent.polaris.specification.api.v1.service.manage.ServiceProto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceInstancesByProto
implements ServiceInstances,
RegistryCacheValue {
    public static final ServiceInstancesByProto EMPTY_INSTANCES = new ServiceInstancesByProto();
    private final ServiceProto.Service service;
    private final ServiceKey svcKey;
    private final List<Instance> instances;
    private final List<ServiceProto.Instance> originInstancesList;
    private final Map<String, InstanceByProto> idMap;
    private final Map<Node, InstanceByProto> nodeMap;
    private final Map<String, String> metadata;
    private final boolean initialized;
    private final int totalWeight;
    private final boolean loadedFromFile;
    private final int hashCode;

    public ServiceInstancesByProto(ResponseProto.DiscoverResponse response, ServiceInstancesByProto oldSvcInstances, boolean loadFromFile) {
        this.service = response.getService();
        ArrayList<InstanceByProto> tmpInstances = new ArrayList<InstanceByProto>();
        HashMap<String, InstanceByProto> tmpInstanceMap = new HashMap<String, InstanceByProto>();
        HashMap<Node, InstanceByProto> tmpNodeMap = new HashMap<Node, InstanceByProto>();
        ArrayList<ServiceProto.Instance> tmpOriginInstances = new ArrayList<ServiceProto.Instance>();
        int totalWeight = 0;
        ServiceKey svcKey = new ServiceKey(this.service.getNamespace().getValue(), this.service.getName().getValue());
        if (CollectionUtils.isNotEmpty(response.getInstancesList())) {
            tmpOriginInstances.addAll(response.getInstancesList());
            for (ServiceProto.Instance instance : response.getInstancesList()) {
                InstanceByProto oldInstance;
                String instID = instance.getId().getValue();
                InstanceLocalValue instanceLocalValue = null;
                if (null != oldSvcInstances && null != (oldInstance = oldSvcInstances.getInstance(instID))) {
                    instanceLocalValue = oldInstance.getInstanceLocalValue();
                }
                if (null == instanceLocalValue) {
                    instanceLocalValue = new DefaultInstanceLocalValue();
                }
                InstanceByProto targetInstance = new InstanceByProto(svcKey, instance, instanceLocalValue);
                totalWeight += targetInstance.getWeight();
                tmpInstances.add(targetInstance);
                tmpInstanceMap.put(instID, targetInstance);
                tmpNodeMap.put(new Node(targetInstance.getHost(), targetInstance.getPort()), targetInstance);
            }
        }
        Collections.sort(tmpInstances);
        this.hashCode = Objects.hash(svcKey, tmpInstances);
        this.svcKey = svcKey;
        this.idMap = Collections.unmodifiableMap(tmpInstanceMap);
        this.nodeMap = Collections.unmodifiableMap(tmpNodeMap);
        this.instances = Collections.unmodifiableList(tmpInstances);
        this.originInstancesList = Collections.unmodifiableList(tmpOriginInstances);
        this.totalWeight = totalWeight;
        this.initialized = true;
        this.metadata = Collections.unmodifiableMap(this.service.getMetadataMap());
        this.loadedFromFile = loadFromFile;
    }

    public ServiceInstancesByProto() {
        this.service = null;
        this.svcKey = null;
        this.initialized = false;
        this.instances = Collections.emptyList();
        this.originInstancesList = Collections.emptyList();
        this.idMap = Collections.emptyMap();
        this.nodeMap = Collections.emptyMap();
        this.metadata = Collections.emptyMap();
        this.loadedFromFile = false;
        this.totalWeight = 0;
        this.hashCode = Objects.hash(this.instances);
    }

    @Override
    public ServiceKey getServiceKey() {
        return this.svcKey;
    }

    @Override
    public int getTotalWeight() {
        return this.totalWeight;
    }

    @Override
    public List<Instance> getInstances() {
        return this.instances;
    }

    @Override
    public boolean isLoadedFromFile() {
        return this.loadedFromFile;
    }

    @Override
    public ServiceEventKey.EventType getEventType() {
        return ServiceEventKey.EventType.INSTANCE;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public String getRevision() {
        if (null != this.service) {
            return this.service.getRevision().getValue();
        }
        return "";
    }

    @Override
    public String getService() {
        if (null != this.service) {
            return this.service.getName().getValue();
        }
        return "";
    }

    @Override
    public String getNamespace() {
        if (null != this.service) {
            return this.service.getNamespace().getValue();
        }
        return "";
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public InstanceByProto getInstance(String instId) {
        return this.idMap.get(instId);
    }

    @Override
    public InstanceByProto getInstance(Node node) {
        return this.nodeMap.get(node);
    }

    public List<ServiceProto.Instance> getOriginInstancesList() {
        return this.originInstancesList;
    }

    public String toString() {
        return "ServiceInstancesByProto{service=" + this.service + ", instances=" + this.instances + ", metadata=" + this.metadata + ", revision='" + this.getRevision() + '\'' + ", initialized=" + this.initialized + ", totalWeight=" + this.totalWeight + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceInstances that = (ServiceInstances)o;
        return Objects.equals(this.svcKey, that.getServiceKey()) && Objects.equals(this.instances, that.getInstances());
    }

    public int hashCode() {
        return this.hashCode;
    }
}

