/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.ApplicationContext;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestClient;

public class LoadBalancerRestClientBuilderBeanPostProcessor
implements BeanPostProcessor {
    private final ClientHttpRequestInterceptor loadBalancerInterceptor;
    private final ApplicationContext context;

    public LoadBalancerRestClientBuilderBeanPostProcessor(ClientHttpRequestInterceptor loadBalancerInterceptor, ApplicationContext context) {
        this.loadBalancerInterceptor = loadBalancerInterceptor;
        this.context = context;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RestClient.Builder) {
            if (this.context.findAnnotationOnBean(beanName, LoadBalanced.class) == null) {
                return bean;
            }
            ((RestClient.Builder)bean).requestInterceptor(this.loadBalancerInterceptor);
        }
        return bean;
    }
}

