/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.report.identifier;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;

public class BaseServiceMetadataIdentifier {
    protected String serviceInterface;
    protected String version;
    protected String group;
    protected String side;

    protected String getUniqueKey(KeyTypeEnum keyType, String ... params) {
        if (keyType == KeyTypeEnum.PATH) {
            return this.getFilePathKey(params);
        }
        return this.getIdentifierKey(params);
    }

    protected String getIdentifierKey(String ... params) {
        String prefix = KeyTypeEnum.UNIQUE_KEY.build(this.serviceInterface, this.version, this.group, this.side);
        return KeyTypeEnum.UNIQUE_KEY.build(prefix, params);
    }

    private String getFilePathKey(String ... params) {
        return this.getFilePathKey("metadata", params);
    }

    private String getFilePathKey(String pathTag, String ... params) {
        String prefix = KeyTypeEnum.PATH.build(pathTag, this.toServicePath(), this.version, this.group, this.side);
        return KeyTypeEnum.PATH.build(prefix, params);
    }

    private String toServicePath() {
        if ("*".equals(this.serviceInterface)) {
            return "";
        }
        return URL.encode(this.serviceInterface);
    }
}

