/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.tcp.connection;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.factory.LoadBalancerFactory;
import org.apache.shenyu.protocol.tcp.UpstreamProvider;
import org.apache.shenyu.protocol.tcp.connection.ClientConnectionConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectionConfigProvider
implements ClientConnectionConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConnectionConfigProvider.class);
    private final String loadBalanceAlgorithm;
    private final String pluginSelectorName;

    public DefaultConnectionConfigProvider(String loadBalanceAlgorithm, String pluginSelectorName) {
        this.loadBalanceAlgorithm = loadBalanceAlgorithm;
        this.pluginSelectorName = pluginSelectorName;
    }

    @Override
    public URI getProxiedService(String ip) {
        List upstreamList = UpstreamProvider.getSingleton().provide(this.pluginSelectorName).stream().map(dp -> Upstream.builder().url(dp.getUrl()).status(this.open(dp.getStatus())).weight(dp.getWeight()).protocol(dp.getProtocol()).warmup(((Integer)JsonUtils.jsonToMap((String)dp.getProps(), Integer.class).get("warmupTime")).intValue()).timestamp(dp.getDateCreated().getTime()).build()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(upstreamList)) {
            throw new ShenyuException("shenyu TcpProxy don't have any upstream");
        }
        Upstream upstream = LoadBalancerFactory.selector(upstreamList, (String)this.loadBalanceAlgorithm, (String)ip);
        return this.cover(upstream);
    }

    private URI cover(Upstream upstream) {
        try {
            return new URI(upstream.getProtocol() + "://" + upstream.getUrl());
        }
        catch (URISyntaxException e) {
            LOG.error("Upstream url is wrong", (Throwable)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    private boolean open(int status) {
        return Objects.equals(status, 0);
    }
}

