/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.tcp.connection;

import com.google.common.eventbus.Subscribe;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;

public class ActivityConnectionObserver
implements ConnectionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(ActivityConnectionObserver.class);
    private final Map<Connection, ConnectionObserver.State> cache = new ConcurrentHashMap<Connection, ConnectionObserver.State>();
    private final String name;

    public ActivityConnectionObserver(String name) {
        this.name = name;
    }

    public void onStateChange(Connection connection, ConnectionObserver.State newState) {
        if (newState == ConnectionObserver.State.CONNECTED) {
            this.cache.put(connection, newState);
            LOG.info("{} add connection into cache ={}", (Object)this.name, (Object)connection);
        } else if (newState == ConnectionObserver.State.DISCONNECTING || newState == ConnectionObserver.State.RELEASED) {
            this.cache.remove(connection);
            LOG.info("{} remove connection into cache ={}", (Object)this.name, (Object)connection);
        } else if (this.cache.containsKey(connection)) {
            this.cache.put(connection, newState);
        }
    }

    @Subscribe
    public void onRemove(List<DiscoveryUpstreamData> remove) {
        LOG.info("shenyu {} ConnectionObserver  do on remove upstreams", (Object)this.name);
        for (Connection connection : this.cache.keySet()) {
            SocketAddress socketAddress = connection.channel().remoteAddress();
            if (!this.in(remove, socketAddress)) continue;
            LOG.info("shenyu dispose {} connection ", (Object)connection);
            connection.disposeNow();
        }
    }

    private boolean in(List<DiscoveryUpstreamData> removeList, SocketAddress cacheSocketAddress) {
        return removeList.stream().anyMatch(u -> {
            String cacheUrl = cacheSocketAddress.toString().substring(1);
            String removedUrl = u.getUrl();
            LOG.info("compare {} , {}", (Object)cacheUrl, (Object)removedUrl);
            return StringUtils.equals((CharSequence)cacheUrl, (CharSequence)removedUrl);
        });
    }
}

