/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.serializer;

import com.weibo.breeze.Breeze;
import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.SchemaLoader;
import com.weibo.breeze.message.Schema;
import com.weibo.breeze.serializer.Serializer;
import com.weibo.breeze.type.Types;
import java.lang.reflect.Method;

public class EnumSerializer
implements Serializer<Enum> {
    private Class enumClz;
    private Method valueOf;
    private Schema schema;
    private String cleanName;
    private String[] names;

    public EnumSerializer(Class enumClz) throws BreezeException {
        if (!enumClz.isEnum()) {
            throw new BreezeException("class type must be enum in EnumSerializer. real type :" + enumClz.getName());
        }
        this.enumClz = enumClz;
        try {
            this.valueOf = enumClz.getMethod("valueOf", Class.class, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new BreezeException("create EnumSerializer fail. e:" + e.getMessage());
        }
        this.schema = SchemaLoader.loadSchema(enumClz.getName());
        if (this.schema != null && !this.schema.isEnum()) {
            for (Schema.Field field : this.schema.getFields().values()) {
                if ("enumValue".equals(field.getName())) continue;
                try {
                    field.setField(enumClz.getDeclaredField(field.getName()));
                }
                catch (NoSuchFieldException e) {
                    throw new BreezeException("create EnumSerializer fail. e:" + e.getMessage());
                }
            }
        }
        this.cleanName = Breeze.getCleanName(enumClz.getName());
        this.names = enumClz.getName().contains("$") ? new String[]{this.cleanName, enumClz.getName()} : new String[]{this.cleanName};
    }

    @Override
    public void writeToBuf(Enum obj, BreezeBuffer buffer) throws BreezeException {
        if (this.schema != null && this.schema.isEnum()) {
            Integer number = this.schema.getEnumNumber(obj.name());
            if (number == null) {
                throw new BreezeException("unknown enum cleanName in breeze schema. class:" + this.enumClz.getName() + ", enum cleanName:" + obj.name());
            }
            BreezeWriter.writeMessage(buffer, () -> Types.TYPE_INT32.writeMessageField(buffer, 1, number));
        } else {
            BreezeWriter.writeMessage(buffer, () -> {
                Types.TYPE_STRING.writeMessageField(buffer, 1, obj.name());
                if (this.schema != null && !this.schema.isEnum()) {
                    for (Schema.Field field : this.schema.getFields().values()) {
                        if ("enumValue".equals(field.getName())) continue;
                        field.writeField(buffer, obj);
                    }
                }
            });
        }
    }

    @Override
    public Enum readFromBuf(BreezeBuffer buffer) throws BreezeException {
        Object[] objects = new Object[2];
        BreezeReader.readMessage(buffer, index -> {
            switch (index) {
                case 1: {
                    String name;
                    if (this.schema != null && this.schema.isEnum()) {
                        int number = BreezeReader.readInt32(buffer);
                        name = this.schema.getEnumValues().get(number);
                        if (name == null) {
                            objects[1] = new BreezeException("unknown enum number " + number);
                            return;
                        }
                    } else {
                        name = BreezeReader.readString(buffer);
                    }
                    try {
                        objects[0] = this.valueOf.invoke(null, this.enumClz, name);
                    }
                    catch (ReflectiveOperationException e) {
                        objects[1] = e;
                    }
                    break;
                }
                default: {
                    BreezeReader.readObject(buffer, Object.class);
                }
            }
        });
        if (objects[0] != null) {
            return (Enum)objects[0];
        }
        throw new BreezeException("read from buf fail in EnumSerializer. class:" + this.enumClz.getName() + ", e:" + ((Exception)objects[1]).getMessage());
    }

    @Override
    public String[] getNames() {
        return this.names;
    }
}

