/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.spi.ExtensionLoader;

public final class ShenyuInstanceRegisterRepositoryFactory {
    private static final Map<String, ShenyuInstanceRegisterRepository> REPOSITORY_MAP = new ConcurrentHashMap<String, ShenyuInstanceRegisterRepository>();

    public static ShenyuInstanceRegisterRepository newInstance(String registerType) {
        return REPOSITORY_MAP.computeIfAbsent(registerType, arg_0 -> ((ExtensionLoader)ExtensionLoader.getExtensionLoader(ShenyuInstanceRegisterRepository.class)).getJoin(arg_0));
    }

    public static ShenyuInstanceRegisterRepository newAndInitInstance(RegisterConfig config) {
        return REPOSITORY_MAP.computeIfAbsent(config.getRegisterType(), registerType -> {
            ShenyuInstanceRegisterRepository result = (ShenyuInstanceRegisterRepository)ExtensionLoader.getExtensionLoader(ShenyuInstanceRegisterRepository.class).getJoin(registerType);
            result.init(config);
            return result;
        });
    }

    public static ShenyuInstanceRegisterRepository reNewAndInitInstance(RegisterConfig config) {
        ShenyuInstanceRegisterRepository result = (ShenyuInstanceRegisterRepository)ExtensionLoader.getExtensionLoader(ShenyuInstanceRegisterRepository.class).getJoin(config.getRegisterType());
        result.init(config);
        REPOSITORY_MAP.put(config.getRegisterType(), result);
        return result;
    }
}

