/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class UriUtils {
    private static final String PRE_FIX = "/";

    public static URI createUri(String uri) {
        if (StringUtils.isNotBlank((CharSequence)uri)) {
            return URI.create(uri);
        }
        return null;
    }

    public static URI createUri(String scheme, String authority, String path) {
        return UriUtils.createUri(scheme + "://" + authority + UriUtils.repairData(path));
    }

    public static String repairData(String name) {
        return name.startsWith(PRE_FIX) ? name : PRE_FIX + name;
    }

    public static String removePrefix(String name) {
        return name.startsWith(PRE_FIX) ? name.substring(1) : name;
    }

    public static String getPathWithParams(URI uri) {
        if (Objects.isNull(uri)) {
            return "";
        }
        String params = StringUtils.isEmpty((CharSequence)uri.getQuery()) ? "" : "?" + uri.getQuery();
        return uri.getRawPath() + params;
    }

    public static String appendScheme(String url, String scheme) {
        Object schemeUrl = url;
        if (!((String)schemeUrl).startsWith("http://") && !((String)schemeUrl).startsWith("https://")) {
            schemeUrl = scheme + "://" + (String)schemeUrl;
        }
        return schemeUrl;
    }

    public static int getActualPort(String scheme, Integer port) {
        Integer actualPort = port;
        if (Objects.isNull(port) || port < 0) {
            if (!"http".equals(scheme) && !"ws".equals(scheme)) {
                if ("https".equals(scheme) || "wss".equals(scheme)) {
                    actualPort = 443;
                }
            } else {
                actualPort = 80;
            }
        }
        return actualPort;
    }
}

