/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.constant;

import org.apache.shenyu.common.constant.Constants;

public final class DefaultPathConstants
implements Constants {
    public static final String SELECTOR_JOIN_RULE = "-";
    public static final String PRE_FIX = "/shenyu";
    public static final String PLUGIN_PARENT = "/shenyu/plugin";
    public static final String SELECTOR_PARENT = "/shenyu/selector";
    public static final String RULE_PARENT = "/shenyu/rule";
    public static final String APP_AUTH_PARENT = "/shenyu/auth";
    public static final String META_DATA = "/shenyu/metaData";
    public static final String PROXY_SELECTOR = "/shenyu/proxySelectorData";
    public static final String DISCOVERY_UPSTREAM = "/shenyu/discoveryUpstream";

    public static String buildAppAuthPath(String namespaceId, String appKey) {
        return DefaultPathConstants.handlePathData(String.join((CharSequence)"/", "/" + namespaceId, APP_AUTH_PARENT, appKey));
    }

    public static String buildMetaDataPath(String namespaceId, String path) {
        return DefaultPathConstants.handlePathData(String.join((CharSequence)"/", "/" + namespaceId, META_DATA, path));
    }

    public static String buildPluginParentPath() {
        return DefaultPathConstants.handlePathData(String.join((CharSequence)"/", PLUGIN_PARENT).replaceAll("//", "/"));
    }

    public static String buildPluginPath(String namespaceId, String pluginName) {
        return DefaultPathConstants.handlePathData(String.join((CharSequence)"/", "/" + namespaceId, PLUGIN_PARENT, pluginName));
    }

    public static String buildSelectorParentPath(String namespaceId, String pluginName) {
        return DefaultPathConstants.handlePathData(String.join((CharSequence)"/", "/" + namespaceId, SELECTOR_PARENT, pluginName));
    }

    public static String buildSelectorRealPath(String namespaceId, String pluginName, String selectorId) {
        return DefaultPathConstants.handlePathData(String.join((CharSequence)"/", "/" + namespaceId, SELECTOR_PARENT, pluginName, selectorId));
    }

    public static String buildRuleParentPath(String namespaceId, String pluginName) {
        return DefaultPathConstants.handlePathData(String.join((CharSequence)"/", "/" + namespaceId, RULE_PARENT, pluginName));
    }

    public static String buildRulePath(String namespaceId, String pluginName, String selectorId, String ruleId) {
        return DefaultPathConstants.handlePathData(String.join((CharSequence)"/", DefaultPathConstants.buildRuleParentPath("/" + namespaceId, pluginName), String.join((CharSequence)SELECTOR_JOIN_RULE, selectorId, ruleId)));
    }

    public static String buildProxySelectorPath(String namespaceId, String pluginName, String proxySelectorName) {
        return DefaultPathConstants.handlePathData(String.join((CharSequence)"/", "/" + namespaceId, PROXY_SELECTOR, pluginName, proxySelectorName));
    }

    public static String buildDiscoveryUpstreamPath(String namespaceId, String pluginName, String proxySelectorName) {
        return DefaultPathConstants.handlePathData(String.join((CharSequence)"/", "/" + namespaceId, DISCOVERY_UPSTREAM, pluginName, proxySelectorName));
    }

    public static String handlePathData(String path) {
        return path.replaceAll("//", "/");
    }
}

