/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.scale.scaler.cache;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.admin.model.entity.ScalePolicyDO;
import org.springframework.stereotype.Component;

@Component
public class ScalePolicyCache {
    private final ConcurrentHashMap<String, ScalePolicyDO> cache = new ConcurrentHashMap();

    public void initialize(List<ScalePolicyDO> policies) {
        this.cache.clear();
        policies.forEach(policy -> this.cache.put(policy.getId(), (ScalePolicyDO)policy));
    }

    public void updatePolicy(ScalePolicyDO policy) {
        this.cache.put(policy.getId(), policy);
    }

    public List<ScalePolicyDO> getAllPolicies() {
        return this.cache.values().stream().toList();
    }

    public ScalePolicyDO getPolicyById(String id) {
        return this.cache.get(id);
    }
}

