/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.mode.cluster.impl.zookeeper;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.ClusterProperties;
import org.apache.shenyu.admin.mode.cluster.impl.zookeeper.ClusterZookeeperClient;
import org.apache.shenyu.admin.mode.cluster.service.ClusterSelectMasterService;
import org.apache.shenyu.admin.model.dto.ClusterMasterDTO;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.zookeeper.lock.ZookeeperLockRegistry;

public class ClusterSelectMasterServiceZookeeperImpl
implements ClusterSelectMasterService {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterSelectMasterServiceZookeeperImpl.class);
    private static final String MASTER_LOCK_KEY = "shenyu_cluster_lock/master";
    private static final String MASTER_INFO = "/shenyu_cluster_lock/master/info";
    private final ClusterProperties clusterProperties;
    private final ClusterZookeeperClient clusterZookeeperClient;
    private final Lock clusterMasterLock;
    private volatile boolean masterFlag;

    public ClusterSelectMasterServiceZookeeperImpl(ClusterProperties clusterProperties, ZookeeperLockRegistry zookeeperLockRegistry, ClusterZookeeperClient clusterZookeeperClient) {
        this.clusterProperties = clusterProperties;
        this.clusterZookeeperClient = clusterZookeeperClient;
        this.clusterMasterLock = zookeeperLockRegistry.obtain((Object)MASTER_LOCK_KEY);
    }

    @Override
    public boolean selectMaster() {
        this.masterFlag = this.clusterMasterLock.tryLock();
        return this.masterFlag;
    }

    @Override
    public boolean selectMaster(String masterHost, String masterPort, String contextPath) {
        this.masterFlag = this.clusterMasterLock.tryLock();
        if (this.masterFlag) {
            HashMap masterInfo = Maps.newHashMap();
            masterInfo.put("masterHost", masterHost);
            masterInfo.put("masterPort", masterPort);
            masterInfo.put("contextPath", contextPath);
            this.clusterZookeeperClient.createOrUpdate(MASTER_INFO, JsonUtils.toJson((Object)masterInfo), CreateMode.PERSISTENT);
        }
        return this.masterFlag;
    }

    @Override
    public boolean checkMasterStatus() {
        return this.masterFlag;
    }

    @Override
    public boolean releaseMaster() {
        if (this.masterFlag) {
            this.clusterMasterLock.unlock();
            this.masterFlag = false;
        }
        return true;
    }

    @Override
    public boolean isMaster() {
        if (!this.clusterProperties.isEnabled()) {
            return true;
        }
        return this.masterFlag;
    }

    @Override
    public ClusterMasterDTO getMaster() {
        String masterInfoJson = this.clusterZookeeperClient.getDirectly(MASTER_INFO);
        return (ClusterMasterDTO)JsonUtils.jsonToObject((String)masterInfoJson, ClusterMasterDTO.class);
    }

    @Override
    public String getMasterUrl() {
        String masterInfoJson = this.clusterZookeeperClient.getDirectly(MASTER_INFO);
        ClusterMasterDTO master = (ClusterMasterDTO)JsonUtils.jsonToObject((String)masterInfoJson, ClusterMasterDTO.class);
        if (StringUtils.isEmpty((CharSequence)master.getContextPath())) {
            return this.clusterProperties.getSchema() + "://" + master.getMasterHost() + ":" + master.getMasterPort();
        }
        return this.clusterProperties.getSchema() + "://" + master.getMasterHost() + ":" + master.getMasterPort() + "/" + master.getContextPath();
    }
}

