/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc.codec;

import com.tencent.polaris.api.plugin.registry.AbstractCacheHandler;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.client.pojo.ServiceRuleByProto;
import com.tencent.polaris.specification.api.v1.fault.tolerance.FaultDetectorProto;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;

public class FaultDetectCacheHandler
extends AbstractCacheHandler {
    @Override
    protected String getRevision(ResponseProto.DiscoverResponse discoverResponse) {
        FaultDetectorProto.FaultDetector faultDetector = discoverResponse.getFaultDetector();
        if (null == faultDetector) {
            return "";
        }
        return faultDetector.getRevision();
    }

    @Override
    public ServiceEventKey.EventType getTargetEventType() {
        return ServiceEventKey.EventType.FAULT_DETECTING;
    }

    @Override
    public RegistryCacheValue messageToCacheValue(RegistryCacheValue oldValue, Object newValue, boolean isCacheLoaded) {
        ResponseProto.DiscoverResponse discoverResponse = (ResponseProto.DiscoverResponse)newValue;
        FaultDetectorProto.FaultDetector faultDetector = discoverResponse.getFaultDetector();
        String revision = "";
        if (null != faultDetector) {
            revision = faultDetector.getRevision();
        }
        return new ServiceRuleByProto(faultDetector, revision, isCacheLoaded, this.getTargetEventType());
    }
}

