/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class ParameterizedTypeUtil
implements ParameterizedType {
    private final Type[] actualTypeArguments;
    private final Class<?> rawType;

    private ParameterizedTypeUtil(Class<?> rawType, Type[] actualTypeArguments) {
        this.actualTypeArguments = actualTypeArguments;
        this.rawType = rawType;
    }

    public static ParameterizedType make(Class<?> rawType, Type ... actualTypeArguments) {
        return new ParameterizedTypeUtil(rawType, actualTypeArguments);
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof ParameterizedType) {
            ParameterizedType that = (ParameterizedType)o;
            if (this == that) {
                return true;
            }
            Type thatRawType = that.getRawType();
            return Objects.equals(this.rawType, thatRawType) && Arrays.equals(this.actualTypeArguments, that.getActualTypeArguments());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.actualTypeArguments) ^ Objects.hashCode(this.rawType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rawType.getName());
        if (this.actualTypeArguments != null) {
            StringJoiner sj = new StringJoiner(", ", "<", ">");
            sj.setEmptyValue("");
            for (Type t : this.actualTypeArguments) {
                sj.add(t.getTypeName());
            }
            sb.append(sj);
        }
        return sb.toString();
    }
}

