/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.pojo;

import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.reflect.TypeToken;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.ParameterGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorUtils;
import org.apache.servicecomb.swagger.generator.core.AbstractOperationGenerator;
import org.apache.servicecomb.swagger.generator.core.AbstractSwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;
import org.apache.servicecomb.swagger.generator.core.utils.MethodUtils;

public class PojoOperationGenerator
extends AbstractOperationGenerator {
    public PojoOperationGenerator(AbstractSwaggerGenerator swaggerGenerator, Method method) {
        super(swaggerGenerator, method);
    }

    @Override
    protected void initParameterGenerators() {
        ArrayList<ParameterGenerator> bodyParameters = new ArrayList<ParameterGenerator>();
        for (Parameter methodParameter : this.method.getParameters()) {
            Type type = TypeToken.of((Class)this.clazz).resolveType(methodParameter.getParameterizedType()).getType();
            ParameterGenerator parameterGenerator = new ParameterGenerator(this, Collections.emptyMap(), methodParameter, TypeFactory.defaultInstance().constructType(type));
            this.validateParameter(parameterGenerator.getGenericType());
            if (SwaggerGeneratorUtils.isContextParameter(parameterGenerator.getGenericType())) continue;
            bodyParameters.add(parameterGenerator);
        }
        this.tryWrapParametersToBody(bodyParameters);
    }

    private void tryWrapParametersToBody(List<ParameterGenerator> bodyParameters) {
        if (bodyParameters.size() == 0) {
            return;
        }
        if (bodyParameters.size() == 1 && SwaggerUtils.isBean((Type)bodyParameters.get(0).getGenericType())) {
            ParameterGenerator parameterGenerator = bodyParameters.get(0);
            parameterGenerator.setHttpParameterType(HttpParameterType.BODY);
            this.parameterGenerators.add(parameterGenerator);
            return;
        }
        this.wrapParametersToBody(bodyParameters);
    }

    private void wrapParametersToBody(List<ParameterGenerator> bodyFields) {
        for (ParameterGenerator parameterGenerator : bodyFields) {
            this.scanMethodParameter(parameterGenerator);
        }
        String simpleRef = MethodUtils.findSwaggerMethodName(this.method) + "Body";
        ObjectSchema bodyModel = new ObjectSchema();
        for (ParameterGenerator parameterGenerator : bodyFields) {
            bodyModel.addProperty(parameterGenerator.getParameterGeneratorContext().getParameterName(), parameterGenerator.getParameterGeneratorContext().getSchema());
        }
        this.swagger.getComponents().addSchemas(simpleRef, (Schema)bodyModel);
        Schema bodyModelNew = new Schema();
        bodyModelNew.set$ref("#/components/schemas/" + simpleRef);
        ParameterGenerator newParameterGenerator = new ParameterGenerator((OperationGenerator)this, simpleRef, bodyModelNew);
        newParameterGenerator.setHttpParameterType(HttpParameterType.BODY);
        this.parameterGenerators.add(newParameterGenerator);
    }

    @Override
    public void correctOperation() {
        this.correctPath();
        this.correctHttpMethod();
        super.correctOperation();
    }

    protected void correctPath() {
        if (StringUtils.isEmpty((CharSequence)this.path)) {
            this.path = "/" + this.getOperationId();
        }
    }

    protected void correctHttpMethod() {
        if (StringUtils.isEmpty((CharSequence)this.httpMethod)) {
            this.setHttpMethod("POST");
        }
    }
}

