/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication.consumer;

import jakarta.ws.rs.core.Response;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.authentication.consumer.ConsumerTokenManager;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.springframework.beans.factory.annotation.Autowired;

public class ConsumerAuthFilter
extends AbstractFilter
implements ConsumerFilter,
EdgeFilter {
    private ConsumerTokenManager authenticationTokenManager;

    @Autowired
    public void setConsumerTokenManager(ConsumerTokenManager consumerTokenManager) {
        this.authenticationTokenManager = consumerTokenManager;
    }

    public int getOrder() {
        return 1010;
    }

    public String getName() {
        return "consumer-public-key";
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        Optional<String> token = Optional.ofNullable(this.authenticationTokenManager.getToken());
        if (!token.isPresent()) {
            return CompletableFuture.failedFuture((Throwable)new InvocationException((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, "auth token is not properly configured yet."));
        }
        invocation.addContext("x-cse-auth-rsatoken", token.get());
        return nextNode.onFilter(invocation);
    }
}

