% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe.R
\name{sd_write_parquet}
\alias{sd_write_parquet}
\title{Write DataFrame to (Geo)Parquet files}
\usage{
sd_write_parquet(
  .data,
  path,
  partition_by = character(0),
  sort_by = character(0),
  single_file_output = NULL,
  geoparquet_version = "1.0",
  overwrite_bbox_columns = FALSE
)
}
\arguments{
\item{.data}{A sedonadb_dataframe}

\item{path}{A filename or directory to which parquet file(s) should be written}

\item{partition_by}{A character vector of column names to partition by. If non-empty,
applies hive-style partitioning to the output}

\item{sort_by}{A character vector of column names to sort by. Currently only
ascending sort is supported}

\item{single_file_output}{Use TRUE or FALSE to force writing a single Parquet
file vs. writing one file per partition to a directory. By default,
a single file is written if \code{partition_by} is unspecified and
\code{path} ends with \code{.parquet}}

\item{geoparquet_version}{GeoParquet metadata version to write if output contains
one or more geometry columns. The default ("1.0") is the most widely
supported and will result in geometry columns being recognized in many
readers; however, only includes statistics at the file level.
Use "1.1" to compute an additional bounding box column
for every geometry column in the output: some readers can use these columns
to prune row groups when files contain an effective spatial ordering.
The extra columns will appear just before their geometry column and
will be named "\link{geom_col_name}_bbox" for all geometry columns except
"geometry", whose bounding box column name is just "bbox"}

\item{overwrite_bbox_columns}{Use TRUE to overwrite any bounding box columns
that already exist in the input. This is useful in a read -> modify
-> write scenario to ensure these columns are up-to-date. If FALSE
(the default), an error will be raised if a bbox column already exists}
}
\value{
The input, invisibly
}
\description{
Write this DataFrame to one or more (Geo)Parquet files. For input that contains
geometry columns, GeoParquet metadata is written such that suitable readers can
recreate Geometry/Geography types when reading the output and potentially read
fewer row groups when only a subset of the file is needed for a given query.
}
\examples{
tmp_parquet <- tempfile(fileext = ".parquet")

sd_sql("SELECT ST_SetSRID(ST_Point(1, 2), 4326) as geom") |>
  sd_write_parquet(tmp_parquet)

sd_read_parquet(tmp_parquet)
unlink(tmp_parquet)

}
