% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{sd_configure_proj}
\alias{sd_configure_proj}
\title{Configure PROJ}
\usage{
sd_configure_proj(
  preset = NULL,
  shared_library = NULL,
  database_path = NULL,
  search_path = NULL
)
}
\arguments{
\item{preset}{One of:
\itemize{
\item \code{"homebrew"}: Look for PROJ installed by Homebrew. This is the easiest
option on MacOS.
\item \code{"system"}: Look for PROJ in the platform library load path (e.g.,
after installing system proj on Linux).
\item \code{"auto"}: Try all presets in the order listed above, issuing a warning
if none can be configured.
}}

\item{shared_library}{An absolute or relative path to a shared library
valid for the platform.}

\item{database_path}{A path to proj.db}

\item{search_path}{A path to the data files required by PROJ for some
transforms.}
}
\value{
NULL, invisibly
}
\description{
Performs a runtime configuration of PROJ, which can be used in place of
a build-time linked version of PROJ or to add in support if PROJ was
not linked at build time.
}
\examples{
sd_configure_proj("auto")

}
