/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.seatunnel.engine.client;

import org.apache.seatunnel.engine.client.job.ClientJobExecutionEnvironment;
import org.apache.seatunnel.engine.client.job.JobClient;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;

import lombok.NonNull;

import java.util.List;

public interface SeaTunnelClientInstance {

    ClientJobExecutionEnvironment createExecutionContext(
            @NonNull String filePath,
            @NonNull JobConfig config,
            @NonNull SeaTunnelConfig seaTunnelConfig);

    ClientJobExecutionEnvironment createExecutionContext(
            @NonNull String filePath,
            List<String> variables,
            @NonNull JobConfig config,
            @NonNull SeaTunnelConfig seaTunnelConfig);

    ClientJobExecutionEnvironment createExecutionContext(
            @NonNull String filePath,
            List<String> variables,
            @NonNull JobConfig config,
            @NonNull SeaTunnelConfig seaTunnelConfig,
            Long jobId);

    ClientJobExecutionEnvironment restoreExecutionContext(
            @NonNull String filePath,
            @NonNull JobConfig config,
            @NonNull SeaTunnelConfig seaTunnelConfig,
            @NonNull Long jobId);

    ClientJobExecutionEnvironment restoreExecutionContext(
            @NonNull String filePath,
            List<String> variables,
            @NonNull JobConfig config,
            @NonNull SeaTunnelConfig seaTunnelConfig,
            @NonNull Long jobId);

    JobClient createJobClient();

    void close();
}
