/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.producer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.client.QueryResult;
import org.apache.rocketmq.client.Validators;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.exception.RequestTimeoutException;
import org.apache.rocketmq.client.impl.MQClientManager;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.lock.ReadWriteCASLock;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.ProduceAccumulator;
import org.apache.rocketmq.client.producer.RequestCallback;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.client.trace.AsyncTraceDispatcher;
import org.apache.rocketmq.client.trace.TraceDispatcher;
import org.apache.rocketmq.client.trace.hook.DefaultRecallMessageTraceHook;
import org.apache.rocketmq.client.trace.hook.EndTransactionTraceHookImpl;
import org.apache.rocketmq.client.trace.hook.SendMessageTraceHookImpl;
import org.apache.rocketmq.common.compression.CompressionType;
import org.apache.rocketmq.common.compression.Compressor;
import org.apache.rocketmq.common.compression.CompressorFactory;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageBatch;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;

public class DefaultMQProducer
extends ClientConfig
implements MQProducer {
    protected final transient DefaultMQProducerImpl defaultMQProducerImpl;
    private final Logger logger = LoggerFactory.getLogger(DefaultMQProducer.class);
    private final Set<Integer> retryResponseCodes = new CopyOnWriteArraySet<Integer>(Arrays.asList(17, 14, 1, 2, 16, 204, 205, 1500));
    private String producerGroup;
    private List<String> topics;
    private String createTopicKey = "TBW102";
    private volatile int defaultTopicQueueNums = 4;
    private int sendMsgTimeout = 3000;
    private int sendMsgMaxTimeoutPerRequest = -1;
    private int compressMsgBodyOverHowmuch = 4096;
    private int retryTimesWhenSendFailed = 2;
    private int retryTimesWhenSendAsyncFailed = 2;
    private boolean retryAnotherBrokerWhenNotStoreOK = false;
    private int maxMessageSize = 0x400000;
    private TraceDispatcher traceDispatcher = null;
    private boolean autoBatch = false;
    private ProduceAccumulator produceAccumulator = null;
    private boolean enableBackpressureForAsyncMode = false;
    private int backPressureForAsyncSendNum = 10000;
    private int backPressureForAsyncSendSize = 0x6400000;
    private int batchMaxDelayMs = -1;
    private long batchMaxBytes = -1L;
    private long totalBatchMaxBytes = -1L;
    private RPCHook rpcHook = null;
    private final ReadWriteCASLock backPressureForAsyncSendNumLock = new ReadWriteCASLock();
    private final ReadWriteCASLock backPressureForAsyncSendSizeLock = new ReadWriteCASLock();
    private int compressLevel = Integer.parseInt(System.getProperty("rocketmq.message.compressLevel", "5"));
    private CompressionType compressType = CompressionType.of((String)System.getProperty("rocketmq.message.compressType", "ZLIB"));
    private Compressor compressor = CompressorFactory.getCompressor((CompressionType)this.compressType);

    public DefaultMQProducer() {
        this("DEFAULT_PRODUCER");
    }

    public DefaultMQProducer(RPCHook rpcHook) {
        this("DEFAULT_PRODUCER", rpcHook);
    }

    public DefaultMQProducer(String producerGroup) {
        this(producerGroup, (RPCHook)null);
    }

    public DefaultMQProducer(String producerGroup, RPCHook rpcHook) {
        this(producerGroup, rpcHook, null);
    }

    public DefaultMQProducer(String producerGroup, RPCHook rpcHook, List<String> topics) {
        this(producerGroup, rpcHook, topics, false, null);
    }

    public DefaultMQProducer(String producerGroup, boolean enableMsgTrace, String customizedTraceTopic) {
        this(producerGroup, null, enableMsgTrace, customizedTraceTopic);
    }

    public DefaultMQProducer(String producerGroup, RPCHook rpcHook, boolean enableMsgTrace, String customizedTraceTopic) {
        this(producerGroup, rpcHook, null, enableMsgTrace, customizedTraceTopic);
    }

    public DefaultMQProducer(String producerGroup, RPCHook rpcHook, List<String> topics, boolean enableMsgTrace, String customizedTraceTopic) {
        this.producerGroup = producerGroup;
        this.rpcHook = rpcHook;
        this.topics = topics;
        this.enableTrace = enableMsgTrace;
        this.traceTopic = customizedTraceTopic;
        this.defaultMQProducerImpl = new DefaultMQProducerImpl(this, rpcHook);
    }

    @Deprecated
    public DefaultMQProducer(String namespace, String producerGroup) {
        this(namespace, producerGroup, null);
    }

    @Deprecated
    public DefaultMQProducer(String namespace, String producerGroup, RPCHook rpcHook) {
        this.namespace = namespace;
        this.producerGroup = producerGroup;
        this.rpcHook = rpcHook;
        this.defaultMQProducerImpl = new DefaultMQProducerImpl(this, rpcHook);
    }

    @Deprecated
    public DefaultMQProducer(String namespace, String producerGroup, RPCHook rpcHook, boolean enableMsgTrace, String customizedTraceTopic) {
        this(namespace, producerGroup, rpcHook);
        this.enableTrace = enableMsgTrace;
        this.traceTopic = customizedTraceTopic;
    }

    @Override
    public void start() throws MQClientException {
        this.setProducerGroup(this.withNamespace(this.producerGroup));
        this.defaultMQProducerImpl.start();
        if (this.produceAccumulator != null) {
            this.produceAccumulator.start();
        }
        if (this.enableTrace) {
            try {
                AsyncTraceDispatcher dispatcher = new AsyncTraceDispatcher(this.producerGroup, TraceDispatcher.Type.PRODUCE, this.getTraceMsgBatchNum(), this.traceTopic, this.rpcHook);
                dispatcher.setHostProducer(this.defaultMQProducerImpl);
                dispatcher.setNamespaceV2(this.namespaceV2);
                this.traceDispatcher = dispatcher;
                this.defaultMQProducerImpl.registerSendMessageHook(new SendMessageTraceHookImpl(this.traceDispatcher));
                this.defaultMQProducerImpl.registerEndTransactionHook(new EndTransactionTraceHookImpl(this.traceDispatcher));
                this.defaultMQProducerImpl.getMqClientFactory().getMQClientAPIImpl().getRemotingClient().registerRPCHook((RPCHook)new DefaultRecallMessageTraceHook(this.traceDispatcher));
            }
            catch (Throwable e) {
                this.logger.error("system mqtrace hook init failed ,maybe can't send msg trace data");
            }
        }
        if (null != this.traceDispatcher) {
            if (this.traceDispatcher instanceof AsyncTraceDispatcher) {
                ((AsyncTraceDispatcher)this.traceDispatcher).getTraceProducer().setUseTLS(this.isUseTLS());
            }
            try {
                this.traceDispatcher.start(this.getNamesrvAddr(), this.getAccessChannel());
            }
            catch (MQClientException e) {
                this.logger.warn("trace dispatcher start failed ", (Throwable)e);
            }
        }
    }

    @Override
    public void shutdown() {
        this.defaultMQProducerImpl.shutdown();
        if (this.produceAccumulator != null) {
            this.produceAccumulator.shutdown();
        }
        if (null != this.traceDispatcher) {
            this.traceDispatcher.shutdown();
        }
    }

    @Override
    public List<MessageQueue> fetchPublishMessageQueues(String topic) throws MQClientException {
        return this.defaultMQProducerImpl.fetchPublishMessageQueues(this.withNamespace(topic));
    }

    private boolean canBatch(Message msg) {
        if (!this.produceAccumulator.tryAddMessage(msg)) {
            return false;
        }
        if (msg.getDelayTimeLevel() > 0 || msg.getDelayTimeMs() > 0L || msg.getDelayTimeSec() > 0L || msg.getDeliverTimeMs() > 0L) {
            return false;
        }
        if (msg.getTopic().startsWith("%RETRY%")) {
            return false;
        }
        return !msg.getProperties().containsKey("PGROUP");
    }

    @Override
    public SendResult send(Message msg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        if (this.getAutoBatch() && !(msg instanceof MessageBatch)) {
            return this.sendByAccumulator(msg, null, null);
        }
        return this.sendDirect(msg, null, null);
    }

    @Override
    public SendResult send(Message msg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.send(msg, timeout);
    }

    @Override
    public void send(Message msg, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        try {
            if (this.getAutoBatch() && !(msg instanceof MessageBatch)) {
                this.sendByAccumulator(msg, null, sendCallback);
            } else {
                this.sendDirect(msg, null, sendCallback);
            }
        }
        catch (Throwable e) {
            sendCallback.onException(e);
        }
    }

    @Override
    public void send(Message msg, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.send(msg, sendCallback, timeout);
    }

    @Override
    public void sendOneway(Message msg) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.sendOneway(msg);
    }

    @Override
    public SendResult send(Message msg, MessageQueue mq) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        mq = this.queueWithNamespace(mq);
        if (this.getAutoBatch() && !(msg instanceof MessageBatch)) {
            return this.sendByAccumulator(msg, mq, null);
        }
        return this.sendDirect(msg, mq, null);
    }

    @Override
    public SendResult send(Message msg, MessageQueue mq, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.send(msg, this.queueWithNamespace(mq), timeout);
    }

    @Override
    public void send(Message msg, MessageQueue mq, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        mq = this.queueWithNamespace(mq);
        try {
            if (this.getAutoBatch() && !(msg instanceof MessageBatch)) {
                this.sendByAccumulator(msg, mq, sendCallback);
            } else {
                this.sendDirect(msg, mq, sendCallback);
            }
        }
        catch (MQBrokerException mQBrokerException) {
            // empty catch block
        }
    }

    @Override
    public void send(Message msg, MessageQueue mq, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.send(msg, this.queueWithNamespace(mq), sendCallback, timeout);
    }

    @Override
    public void sendOneway(Message msg, MessageQueue mq) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.sendOneway(msg, this.queueWithNamespace(mq));
    }

    @Override
    public SendResult send(Message msg, MessageQueueSelector selector, Object arg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        MessageQueue mq = this.defaultMQProducerImpl.invokeMessageQueueSelector(msg, selector, arg, this.getSendMsgTimeout());
        mq = this.queueWithNamespace(mq);
        if (this.getAutoBatch() && !(msg instanceof MessageBatch)) {
            return this.sendByAccumulator(msg, mq, null);
        }
        return this.sendDirect(msg, mq, null);
    }

    @Override
    public SendResult send(Message msg, MessageQueueSelector selector, Object arg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.send(msg, selector, arg, timeout);
    }

    @Override
    public void send(Message msg, MessageQueueSelector selector, Object arg, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        try {
            MessageQueue mq = this.defaultMQProducerImpl.invokeMessageQueueSelector(msg, selector, arg, this.getSendMsgTimeout());
            mq = this.queueWithNamespace(mq);
            if (this.getAutoBatch() && !(msg instanceof MessageBatch)) {
                this.sendByAccumulator(msg, mq, sendCallback);
            } else {
                this.sendDirect(msg, mq, sendCallback);
            }
        }
        catch (Throwable e) {
            sendCallback.onException(e);
        }
    }

    @Override
    public void send(Message msg, MessageQueueSelector selector, Object arg, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.send(msg, selector, arg, sendCallback, timeout);
    }

    public SendResult sendDirect(Message msg, MessageQueue mq, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException, MQBrokerException {
        if (sendCallback == null) {
            if (mq == null) {
                return this.defaultMQProducerImpl.send(msg);
            }
            return this.defaultMQProducerImpl.send(msg, mq);
        }
        if (mq == null) {
            this.defaultMQProducerImpl.send(msg, sendCallback);
        } else {
            this.defaultMQProducerImpl.send(msg, mq, sendCallback);
        }
        return null;
    }

    public SendResult sendByAccumulator(Message msg, MessageQueue mq, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException, MQBrokerException {
        if (!this.canBatch(msg)) {
            return this.sendDirect(msg, mq, sendCallback);
        }
        Validators.checkMessage(msg, this);
        MessageClientIDSetter.setUniqID((Message)msg);
        if (sendCallback == null) {
            return this.produceAccumulator.send(msg, mq, this);
        }
        this.produceAccumulator.send(msg, mq, sendCallback, this);
        return null;
    }

    @Override
    public Message request(Message msg, long timeout) throws RequestTimeoutException, MQClientException, RemotingException, MQBrokerException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.request(msg, timeout);
    }

    @Override
    public void request(Message msg, RequestCallback requestCallback, long timeout) throws MQClientException, RemotingException, InterruptedException, MQBrokerException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.request(msg, requestCallback, timeout);
    }

    @Override
    public Message request(Message msg, MessageQueueSelector selector, Object arg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException, RequestTimeoutException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.request(msg, selector, arg, timeout);
    }

    @Override
    public void request(Message msg, MessageQueueSelector selector, Object arg, RequestCallback requestCallback, long timeout) throws MQClientException, RemotingException, InterruptedException, MQBrokerException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.request(msg, selector, arg, requestCallback, timeout);
    }

    @Override
    public Message request(Message msg, MessageQueue mq, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException, RequestTimeoutException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        return this.defaultMQProducerImpl.request(msg, mq, timeout);
    }

    @Override
    public void request(Message msg, MessageQueue mq, RequestCallback requestCallback, long timeout) throws MQClientException, RemotingException, InterruptedException, MQBrokerException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.request(msg, mq, requestCallback, timeout);
    }

    @Override
    public void sendOneway(Message msg, MessageQueueSelector selector, Object arg) throws MQClientException, RemotingException, InterruptedException {
        msg.setTopic(this.withNamespace(msg.getTopic()));
        this.defaultMQProducerImpl.sendOneway(msg, selector, arg);
    }

    @Override
    public TransactionSendResult sendMessageInTransaction(Message msg, Object arg) throws MQClientException {
        throw new RuntimeException("sendMessageInTransaction not implement, please use TransactionMQProducer class");
    }

    @Override
    @Deprecated
    public void createTopic(String key, String newTopic, int queueNum, Map<String, String> attributes) throws MQClientException {
        this.createTopic(key, this.withNamespace(newTopic), queueNum, 0, null);
    }

    @Override
    @Deprecated
    public void createTopic(String key, String newTopic, int queueNum, int topicSysFlag, Map<String, String> attributes) throws MQClientException {
        this.defaultMQProducerImpl.createTopic(key, this.withNamespace(newTopic), queueNum, topicSysFlag);
    }

    @Override
    public long searchOffset(MessageQueue mq, long timestamp) throws MQClientException {
        return this.defaultMQProducerImpl.searchOffset(this.queueWithNamespace(mq), timestamp);
    }

    @Override
    @Deprecated
    public long maxOffset(MessageQueue mq) throws MQClientException {
        return this.defaultMQProducerImpl.maxOffset(this.queueWithNamespace(mq));
    }

    @Override
    @Deprecated
    public long minOffset(MessageQueue mq) throws MQClientException {
        return this.defaultMQProducerImpl.minOffset(this.queueWithNamespace(mq));
    }

    @Override
    @Deprecated
    public long earliestMsgStoreTime(MessageQueue mq) throws MQClientException {
        return this.defaultMQProducerImpl.earliestMsgStoreTime(this.queueWithNamespace(mq));
    }

    @Override
    @Deprecated
    public QueryResult queryMessage(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        return this.defaultMQProducerImpl.queryMessage(this.withNamespace(topic), key, maxNum, begin, end);
    }

    @Override
    @Deprecated
    public MessageExt viewMessage(String topic, String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        try {
            return this.defaultMQProducerImpl.viewMessage(topic, msgId);
        }
        catch (Exception exception) {
            return this.defaultMQProducerImpl.queryMessageByUniqKey(this.withNamespace(topic), msgId);
        }
    }

    @Override
    public SendResult send(Collection<Message> msgs) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.defaultMQProducerImpl.send((Message)this.batch(msgs));
    }

    @Override
    public SendResult send(Collection<Message> msgs, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.defaultMQProducerImpl.send((Message)this.batch(msgs), timeout);
    }

    @Override
    public SendResult send(Collection<Message> msgs, MessageQueue messageQueue) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.defaultMQProducerImpl.send((Message)this.batch(msgs), messageQueue);
    }

    @Override
    public SendResult send(Collection<Message> msgs, MessageQueue messageQueue, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.defaultMQProducerImpl.send((Message)this.batch(msgs), messageQueue, timeout);
    }

    @Override
    public void send(Collection<Message> msgs, SendCallback sendCallback) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.defaultMQProducerImpl.send((Message)this.batch(msgs), sendCallback);
    }

    @Override
    public void send(Collection<Message> msgs, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.defaultMQProducerImpl.send((Message)this.batch(msgs), sendCallback, timeout);
    }

    @Override
    public void send(Collection<Message> msgs, MessageQueue mq, SendCallback sendCallback) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.defaultMQProducerImpl.send((Message)this.batch(msgs), this.queueWithNamespace(mq), sendCallback);
    }

    @Override
    public void send(Collection<Message> msgs, MessageQueue mq, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.defaultMQProducerImpl.send((Message)this.batch(msgs), this.queueWithNamespace(mq), sendCallback, timeout);
    }

    @Override
    public String recallMessage(String topic, String recallHandle) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.defaultMQProducerImpl.recallMessage(this.withNamespace(topic), recallHandle);
    }

    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.defaultMQProducerImpl.setCallbackExecutor(callbackExecutor);
    }

    public void setAsyncSenderExecutor(ExecutorService asyncSenderExecutor) {
        this.defaultMQProducerImpl.setAsyncSenderExecutor(asyncSenderExecutor);
    }

    public void addRetryResponseCode(int responseCode) {
        this.retryResponseCodes.add(responseCode);
    }

    private MessageBatch batch(Collection<Message> msgs) throws MQClientException {
        MessageBatch msgBatch;
        try {
            msgBatch = MessageBatch.generateFromList(msgs);
            for (Message message : msgBatch) {
                Validators.checkMessage(message, this);
                MessageClientIDSetter.setUniqID((Message)message);
                message.setTopic(this.withNamespace(message.getTopic()));
            }
            MessageClientIDSetter.setUniqID((Message)msgBatch);
            msgBatch.setBody(msgBatch.encode());
        }
        catch (Exception e) {
            throw new MQClientException("Failed to initiate the MessageBatch", e);
        }
        msgBatch.setTopic(this.withNamespace(msgBatch.getTopic()));
        return msgBatch;
    }

    public int getBatchMaxDelayMs() {
        if (this.produceAccumulator == null) {
            return 0;
        }
        return this.produceAccumulator.getBatchMaxDelayMs();
    }

    public void batchMaxDelayMs(int holdMs) {
        this.batchMaxDelayMs = holdMs;
        if (this.produceAccumulator != null) {
            this.produceAccumulator.batchMaxDelayMs(holdMs);
        }
    }

    public long getBatchMaxBytes() {
        if (this.produceAccumulator == null) {
            return 0L;
        }
        return this.produceAccumulator.getBatchMaxBytes();
    }

    public void batchMaxBytes(long holdSize) {
        this.batchMaxBytes = holdSize;
        if (this.produceAccumulator != null) {
            this.produceAccumulator.batchMaxBytes(holdSize);
        }
    }

    public long getTotalBatchMaxBytes() {
        if (this.produceAccumulator == null) {
            return 0L;
        }
        return this.produceAccumulator.getTotalBatchMaxBytes();
    }

    public void totalBatchMaxBytes(long totalHoldSize) {
        this.totalBatchMaxBytes = totalHoldSize;
        if (this.produceAccumulator != null) {
            this.produceAccumulator.totalBatchMaxBytes(totalHoldSize);
        }
    }

    public boolean getAutoBatch() {
        if (this.produceAccumulator == null) {
            return false;
        }
        return this.autoBatch;
    }

    public void setAutoBatch(boolean autoBatch) {
        this.autoBatch = autoBatch;
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    public String getCreateTopicKey() {
        return this.createTopicKey;
    }

    public void setCreateTopicKey(String createTopicKey) {
        this.createTopicKey = createTopicKey;
    }

    public int getSendMsgTimeout() {
        return this.sendMsgTimeout;
    }

    public void setSendMsgTimeout(int sendMsgTimeout) {
        this.sendMsgTimeout = sendMsgTimeout;
    }

    public int getSendMsgMaxTimeoutPerRequest() {
        return this.sendMsgMaxTimeoutPerRequest;
    }

    public void setSendMsgMaxTimeoutPerRequest(int sendMsgMaxTimeoutPerRequest) {
        this.sendMsgMaxTimeoutPerRequest = sendMsgMaxTimeoutPerRequest;
    }

    public int getCompressMsgBodyOverHowmuch() {
        return this.compressMsgBodyOverHowmuch;
    }

    public void setCompressMsgBodyOverHowmuch(int compressMsgBodyOverHowmuch) {
        this.compressMsgBodyOverHowmuch = compressMsgBodyOverHowmuch;
    }

    @Deprecated
    public DefaultMQProducerImpl getDefaultMQProducerImpl() {
        return this.defaultMQProducerImpl;
    }

    public boolean isRetryAnotherBrokerWhenNotStoreOK() {
        return this.retryAnotherBrokerWhenNotStoreOK;
    }

    public void setRetryAnotherBrokerWhenNotStoreOK(boolean retryAnotherBrokerWhenNotStoreOK) {
        this.retryAnotherBrokerWhenNotStoreOK = retryAnotherBrokerWhenNotStoreOK;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getDefaultTopicQueueNums() {
        return this.defaultTopicQueueNums;
    }

    public void setDefaultTopicQueueNums(int defaultTopicQueueNums) {
        this.defaultTopicQueueNums = defaultTopicQueueNums;
    }

    public int getRetryTimesWhenSendFailed() {
        return this.retryTimesWhenSendFailed;
    }

    public void setRetryTimesWhenSendFailed(int retryTimesWhenSendFailed) {
        this.retryTimesWhenSendFailed = retryTimesWhenSendFailed;
    }

    public boolean isSendMessageWithVIPChannel() {
        return this.isVipChannelEnabled();
    }

    public void setSendMessageWithVIPChannel(boolean sendMessageWithVIPChannel) {
        this.setVipChannelEnabled(sendMessageWithVIPChannel);
    }

    public long[] getNotAvailableDuration() {
        return this.defaultMQProducerImpl.getNotAvailableDuration();
    }

    public void setNotAvailableDuration(long[] notAvailableDuration) {
        this.defaultMQProducerImpl.setNotAvailableDuration(notAvailableDuration);
    }

    public long[] getLatencyMax() {
        return this.defaultMQProducerImpl.getLatencyMax();
    }

    public void setLatencyMax(long[] latencyMax) {
        this.defaultMQProducerImpl.setLatencyMax(latencyMax);
    }

    public boolean isSendLatencyFaultEnable() {
        return this.defaultMQProducerImpl.isSendLatencyFaultEnable();
    }

    public void setSendLatencyFaultEnable(boolean sendLatencyFaultEnable) {
        this.defaultMQProducerImpl.setSendLatencyFaultEnable(sendLatencyFaultEnable);
    }

    public int getRetryTimesWhenSendAsyncFailed() {
        return this.retryTimesWhenSendAsyncFailed;
    }

    public void setRetryTimesWhenSendAsyncFailed(int retryTimesWhenSendAsyncFailed) {
        this.retryTimesWhenSendAsyncFailed = retryTimesWhenSendAsyncFailed;
    }

    public TraceDispatcher getTraceDispatcher() {
        return this.traceDispatcher;
    }

    public Set<Integer> getRetryResponseCodes() {
        return this.retryResponseCodes;
    }

    public boolean isEnableBackpressureForAsyncMode() {
        return this.enableBackpressureForAsyncMode;
    }

    public void setEnableBackpressureForAsyncMode(boolean enableBackpressureForAsyncMode) {
        this.enableBackpressureForAsyncMode = enableBackpressureForAsyncMode;
    }

    public int getBackPressureForAsyncSendNum() {
        return this.backPressureForAsyncSendNum;
    }

    public void setBackPressureForAsyncSendNum(int backPressureForAsyncSendNum) {
        this.backPressureForAsyncSendNumLock.acquireWriteLock();
        backPressureForAsyncSendNum = Math.max(backPressureForAsyncSendNum, 10);
        int acquiredBackPressureForAsyncSendNum = this.backPressureForAsyncSendNum - this.defaultMQProducerImpl.getSemaphoreAsyncSendNumAvailablePermits();
        this.backPressureForAsyncSendNum = backPressureForAsyncSendNum;
        this.defaultMQProducerImpl.setSemaphoreAsyncSendNum(backPressureForAsyncSendNum - acquiredBackPressureForAsyncSendNum);
        this.backPressureForAsyncSendNumLock.releaseWriteLock();
    }

    public int getBackPressureForAsyncSendSize() {
        return this.backPressureForAsyncSendSize;
    }

    public void setBackPressureForAsyncSendSize(int backPressureForAsyncSendSize) {
        this.backPressureForAsyncSendSizeLock.acquireWriteLock();
        backPressureForAsyncSendSize = Math.max(backPressureForAsyncSendSize, 0x100000);
        int acquiredBackPressureForAsyncSendSize = this.backPressureForAsyncSendSize - this.defaultMQProducerImpl.getSemaphoreAsyncSendSizeAvailablePermits();
        this.backPressureForAsyncSendSize = backPressureForAsyncSendSize;
        this.defaultMQProducerImpl.setSemaphoreAsyncSendSize(backPressureForAsyncSendSize - acquiredBackPressureForAsyncSendSize);
        this.backPressureForAsyncSendSizeLock.releaseWriteLock();
    }

    public void setBackPressureForAsyncSendSizeInsideAdjust(int backPressureForAsyncSendSize) {
        this.backPressureForAsyncSendSize = backPressureForAsyncSendSize;
    }

    public void setBackPressureForAsyncSendNumInsideAdjust(int backPressureForAsyncSendNum) {
        this.backPressureForAsyncSendNum = backPressureForAsyncSendNum;
    }

    public void acquireBackPressureForAsyncSendSizeLock() {
        this.backPressureForAsyncSendSizeLock.acquireReadLock();
    }

    public void releaseBackPressureForAsyncSendSizeLock() {
        this.backPressureForAsyncSendSizeLock.releaseReadLock();
    }

    public void acquireBackPressureForAsyncSendNumLock() {
        this.backPressureForAsyncSendNumLock.acquireReadLock();
    }

    public void releaseBackPressureForAsyncSendNumLock() {
        this.backPressureForAsyncSendNumLock.releaseReadLock();
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    @Override
    public void setStartDetectorEnable(boolean startDetectorEnable) {
        super.setStartDetectorEnable(startDetectorEnable);
        this.defaultMQProducerImpl.getMqFaultStrategy().setStartDetectorEnable(startDetectorEnable);
    }

    public int getCompressLevel() {
        return this.compressLevel;
    }

    public void setCompressLevel(int compressLevel) {
        this.compressLevel = compressLevel;
    }

    public CompressionType getCompressType() {
        return this.compressType;
    }

    public void setCompressType(CompressionType compressType) {
        this.compressType = compressType;
        this.compressor = CompressorFactory.getCompressor((CompressionType)compressType);
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    public void initProduceAccumulator() {
        this.produceAccumulator = MQClientManager.getInstance().getOrCreateProduceAccumulator(this);
        if (this.batchMaxDelayMs > -1) {
            this.produceAccumulator.batchMaxDelayMs(this.batchMaxDelayMs);
        }
        if (this.batchMaxBytes > -1L) {
            this.produceAccumulator.batchMaxBytes(this.batchMaxBytes);
        }
        if (this.totalBatchMaxBytes > -1L) {
            this.produceAccumulator.totalBatchMaxBytes(this.totalBatchMaxBytes);
        }
    }
}

