/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.exception.ConsumeQueueException;
import org.apache.rocketmq.store.queue.OffsetInitializer;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueStore;
import org.rocksdb.RocksDBException;

public class OffsetInitializerRocksDBImpl
implements OffsetInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffsetInitializerRocksDBImpl.class);
    private final RocksDBConsumeQueueStore consumeQueueStore;

    public OffsetInitializerRocksDBImpl(RocksDBConsumeQueueStore consumeQueueStore) {
        this.consumeQueueStore = consumeQueueStore;
    }

    @Override
    public long maxConsumeQueueOffset(String topic, int queueId) throws ConsumeQueueException {
        try {
            long offset = this.consumeQueueStore.getMaxOffsetInQueue(topic, queueId);
            LOGGER.info("Look up RocksDB for max-offset of LMQ[{}:{}]: {}", new Object[]{topic, queueId, offset});
            return offset;
        }
        catch (RocksDBException e) {
            throw new ConsumeQueueException(e);
        }
    }
}

