/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;

public class RangerAccessRequestWrapper
implements RangerAccessRequest {
    private final RangerAccessRequest request;
    private final String accessType;
    private final boolean isAccessTypeAny;
    private final boolean isAccessTypeDelegatedAdmin;

    public RangerAccessRequestWrapper(RangerAccessRequest request, String accessType) {
        this.request = request;
        this.accessType = accessType;
        this.isAccessTypeAny = StringUtils.equals((String)accessType, (String)"_any");
        this.isAccessTypeDelegatedAdmin = StringUtils.equals((String)accessType, (String)"_admin");
    }

    @Override
    public RangerAccessResource getResource() {
        return this.request.getResource();
    }

    @Override
    public String getAccessType() {
        return this.accessType;
    }

    @Override
    public boolean ignoreDescendantDeny() {
        return this.request.ignoreDescendantDeny();
    }

    @Override
    public boolean isAccessTypeAny() {
        return this.isAccessTypeAny;
    }

    @Override
    public boolean isAccessTypeDelegatedAdmin() {
        return this.isAccessTypeDelegatedAdmin;
    }

    @Override
    public String getUser() {
        return this.request.getUser();
    }

    @Override
    public Set<String> getUserGroups() {
        return this.request.getUserGroups();
    }

    @Override
    public Set<String> getUserRoles() {
        return this.request.getUserRoles();
    }

    @Override
    public Date getAccessTime() {
        return this.request.getAccessTime();
    }

    @Override
    public String getClientIPAddress() {
        return this.request.getClientIPAddress();
    }

    @Override
    public String getRemoteIPAddress() {
        return this.request.getRemoteIPAddress();
    }

    @Override
    public List<String> getForwardedAddresses() {
        return this.request.getForwardedAddresses();
    }

    @Override
    public String getClientType() {
        return this.request.getClientType();
    }

    @Override
    public String getAction() {
        return this.request.getAction();
    }

    @Override
    public String getRequestData() {
        return this.request.getRequestData();
    }

    @Override
    public String getSessionId() {
        return this.request.getSessionId();
    }

    @Override
    public String getClusterName() {
        return this.request.getClusterName();
    }

    @Override
    public String getClusterType() {
        return this.request.getClusterType();
    }

    @Override
    public Map<String, Object> getContext() {
        return this.request.getContext();
    }

    @Override
    public RangerAccessRequest getReadOnlyCopy() {
        return this.request.getReadOnlyCopy();
    }

    @Override
    public RangerAccessRequest.ResourceMatchingScope getResourceMatchingScope() {
        return this.request.getResourceMatchingScope();
    }

    @Override
    public Map<String, RangerAccessRequest.ResourceElementMatchingScope> getResourceElementMatchingScopes() {
        return this.request.getResourceElementMatchingScopes();
    }
}

