/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.thirdparty.com.google.common.collect.ComparisonChain;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ElasticByteBufferPool
implements ByteBufferPool {
    private final TreeMap<Key, ByteBuffer> buffers = new TreeMap();
    private final TreeMap<Key, ByteBuffer> directBuffers = new TreeMap();

    private final TreeMap<Key, ByteBuffer> getBufferTree(boolean direct) {
        return direct ? this.directBuffers : this.buffers;
    }

    @Override
    public synchronized ByteBuffer getBuffer(boolean direct, int length) {
        TreeMap<Key, ByteBuffer> tree = this.getBufferTree(direct);
        Map.Entry<Key, ByteBuffer> entry = tree.ceilingEntry(new Key(length, 0L));
        if (entry == null) {
            return direct ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
        }
        tree.remove(entry.getKey());
        entry.getValue().clear();
        return entry.getValue();
    }

    @Override
    public synchronized void putBuffer(ByteBuffer buffer) {
        Key key;
        buffer.clear();
        TreeMap<Key, ByteBuffer> tree = this.getBufferTree(buffer.isDirect());
        while (tree.containsKey(key = new Key(buffer.capacity(), System.nanoTime()))) {
        }
        tree.put(key, buffer);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public int size(boolean direct) {
        return this.getBufferTree(direct).size();
    }

    protected static final class Key
    implements Comparable<Key> {
        private final int capacity;
        private final long insertionTime;

        Key(int capacity, long insertionTime) {
            this.capacity = capacity;
            this.insertionTime = insertionTime;
        }

        @Override
        public int compareTo(Key other) {
            return ComparisonChain.start().compare(this.capacity, other.capacity).compare(this.insertionTime, other.insertionTime).result();
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            try {
                Key o = (Key)rhs;
                return this.compareTo(o) == 0;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.capacity).append(this.insertionTime).toHashCode();
        }
    }
}

