/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.metrics;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.MaxMetric;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class PercentileMetric
extends Metric {
    private long longMax = Long.MIN_VALUE;
    private double doubleMax = -1.7976931348623157E308;
    private String columnName;

    public PercentileMetric(String columnName, int percentile) {
        this.init("per", columnName, percentile);
    }

    public PercentileMetric(StreamExpression expression, StreamFactory factory) throws IOException {
        String functionName = expression.getFunctionName();
        String columnName = factory.getValueOperand(expression, 0);
        int percentile = Integer.parseInt(factory.getValueOperand(expression, 1));
        if (null == columnName) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expected %s(columnName)", expression, functionName));
        }
        if (2 != expression.getParameters().size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        this.init(functionName, columnName, percentile);
    }

    private void init(String functionName, String columnName, int percentile) {
        this.columnName = columnName;
        this.setFunctionName(functionName);
        this.setIdentifier(functionName, "(", columnName, "," + percentile, ")");
    }

    @Override
    public Number getValue() {
        if (this.longMax == Long.MIN_VALUE) {
            return this.doubleMax;
        }
        return this.longMax;
    }

    @Override
    public String[] getColumns() {
        return new String[]{this.columnName};
    }

    @Override
    public void update(Tuple tuple) {
    }

    @Override
    public Metric newInstance() {
        return new MaxMetric(this.columnName);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return new StreamExpression(this.getFunctionName()).withParameter(this.columnName);
    }
}

