/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.client.solrj.routing.RequestReplicaListTransformerGenerator;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public abstract class TupleStream
implements Closeable,
Serializable,
MapWriter {
    private static final long serialVersionUID = 1L;
    private UUID streamNodeId = UUID.randomUUID();

    public abstract void setStreamContext(StreamContext var1);

    public abstract List<TupleStream> children();

    public abstract void open() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract Tuple read() throws IOException;

    public abstract StreamComparator getStreamSort();

    public abstract Explanation toExplanation(StreamFactory var1) throws IOException;

    public int getCost() {
        return 0;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        this.open();
        ew.put((CharSequence)"docs", iw -> {
            try {
                Tuple tuple;
                while ((tuple = this.read()) != null) {
                    iw.add(tuple);
                    if (!tuple.EOF) continue;
                    this.close();
                    break;
                }
            }
            catch (Throwable e) {
                this.close();
                for (Throwable ex = e; ex != null; ex = ex.getCause()) {
                    String m = ex.getMessage();
                    if (m == null || !m.contains("Broken pipe")) continue;
                    throw new IgnoreException();
                }
                if (e instanceof IOException) {
                    throw e;
                }
                throw new IOException(e);
            }
        });
    }

    public UUID getStreamNodeId() {
        return this.streamNodeId;
    }

    public static List<String> getShards(String zkHost, String collection, StreamContext streamContext) throws IOException {
        return TupleStream.getShards(zkHost, collection, streamContext, new ModifiableSolrParams());
    }

    static List<Replica> getReplicas(String zkHost, String collection, StreamContext streamContext, SolrParams requestParams) throws IOException {
        RequestReplicaListTransformerGenerator requestReplicaListTransformerGenerator;
        ModifiableSolrParams solrParams;
        SolrClientCache localSolrClientCache;
        SolrClientCache solrClientCache;
        LinkedList<Replica> replicas = new LinkedList<Replica>();
        SolrClientCache solrClientCache2 = solrClientCache = streamContext != null ? streamContext.getSolrClientCache() : null;
        if (solrClientCache == null) {
            solrClientCache = localSolrClientCache = new SolrClientCache();
        } else {
            localSolrClientCache = null;
        }
        if (zkHost == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression - zkHost not found for collection '%s'", collection));
        }
        CloudSolrClient cloudSolrClient = solrClientCache.getCloudSolrClient(zkHost);
        ZkStateReader zkStateReader = cloudSolrClient.getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        Slice[] slices = CloudSolrStream.getSlices(collection, zkStateReader, true);
        Set<String> liveNodes = clusterState.getLiveNodes();
        if (streamContext != null) {
            solrParams = new ModifiableSolrParams(streamContext.getRequestParams());
            requestReplicaListTransformerGenerator = streamContext.getRequestReplicaListTransformerGenerator();
        } else {
            solrParams = new ModifiableSolrParams();
            requestReplicaListTransformerGenerator = null;
        }
        if (requestReplicaListTransformerGenerator == null) {
            requestReplicaListTransformerGenerator = new RequestReplicaListTransformerGenerator();
        }
        solrParams.add(requestParams);
        ReplicaListTransformer replicaListTransformer = requestReplicaListTransformerGenerator.getReplicaListTransformer(solrParams);
        ArrayList sortedReplicas = new ArrayList();
        for (Slice slice : slices) {
            slice.getReplicas().stream().filter(r -> r.isActive(liveNodes)).forEach(sortedReplicas::add);
            replicaListTransformer.transform(sortedReplicas);
            if (sortedReplicas.size() > 0) {
                replicas.add((Replica)sortedReplicas.get(0));
            }
            sortedReplicas.clear();
        }
        if (localSolrClientCache != null) {
            localSolrClientCache.close();
        }
        return replicas;
    }

    public static List<String> getShards(String zkHost, String collection, StreamContext streamContext, SolrParams requestParams) throws IOException {
        Map shardsMap = streamContext != null ? (Map)streamContext.get("shards") : null;
        List shards = shardsMap != null ? (List)shardsMap.get(collection) : TupleStream.getReplicas(zkHost, collection, streamContext, requestParams).stream().map(Replica::getCoreUrl).collect(Collectors.toList());
        return shards;
    }

    public static class IgnoreException
    extends IOException {
        @Override
        public void printStackTrace(PrintWriter pw) {
            pw.print("Early Client Disconnect");
        }

        @Override
        public String getMessage() {
            return "Early Client Disconnect";
        }
    }
}

