/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.ops;

import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.ops.StreamOperation;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ConcatOperation
implements StreamOperation {
    private static final long serialVersionUID = 1L;
    private UUID operationNodeId = UUID.randomUUID();
    private String[] fields;
    private String as;
    private String delim;

    public ConcatOperation(String[] fields, String as, String delim) {
        this.fields = fields;
        this.as = as;
        this.delim = delim;
    }

    public ConcatOperation(StreamExpression expression, StreamFactory factory) throws IOException {
        if (3 == expression.getParameters().size()) {
            StreamExpressionNamedParameter fieldsParam = factory.getNamedOperand(expression, "fields");
            String fieldsStr = ((StreamExpressionValue)fieldsParam.getParameter()).getValue();
            this.fields = fieldsStr.split(",");
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = this.fields[i].trim();
            }
        } else {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        StreamExpressionNamedParameter asParam = factory.getNamedOperand(expression, "as");
        this.as = ((StreamExpressionValue)asParam.getParameter()).getValue();
        StreamExpressionNamedParameter delim = factory.getNamedOperand(expression, "delim");
        this.delim = ((StreamExpressionValue)delim.getParameter()).getValue();
    }

    @Override
    public void operate(Tuple tuple) {
        StringBuilder buf = new StringBuilder();
        for (String field : this.fields) {
            Object value;
            if (buf.length() > 0) {
                buf.append(this.delim);
            }
            if (null == (value = tuple.get(field))) {
                value = "null";
            }
            buf.append(value);
        }
        tuple.put(this.as, buf.toString());
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        StringBuilder sb = new StringBuilder();
        for (String field : this.fields) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(field);
        }
        expression.addParameter(new StreamExpressionNamedParameter("fields", sb.toString()));
        expression.addParameter(new StreamExpressionNamedParameter("delim", this.delim));
        expression.addParameter(new StreamExpressionNamedParameter("as", this.as));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.operationNodeId.toString()).withExpressionType("operation").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

