/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientCache
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, SolrClient> solrClients = new HashMap<String, SolrClient>();
    private final HttpClient httpClient;
    private static final int conTimeout = Math.max(Integer.parseInt(System.getProperty("connTimeout", "60000")), 60000);
    private static final int socketTimeout = Math.max(Integer.parseInt(System.getProperty("socketTimeout", "60000")), 60000);
    private final AtomicReference<String> defaultZkHost = new AtomicReference();

    public SolrClientCache() {
        this.httpClient = null;
    }

    public SolrClientCache(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setDefaultZKHost(String zkHost) {
        if (zkHost != null) {
            if (!(zkHost = zkHost.split("/")[0]).isEmpty()) {
                this.defaultZkHost.set(zkHost);
            } else {
                this.defaultZkHost.set(null);
            }
        }
    }

    public synchronized CloudSolrClient getCloudSolrClient(String zkHost) {
        CloudSolrClient client;
        assert (conTimeout >= 60000);
        assert (socketTimeout >= 60000);
        if (log.isDebugEnabled()) {
            log.debug("SolrClientCache.conTimeout: {}", (Object)conTimeout);
            log.debug("SolrClientCache.socketTimeout: {}", (Object)socketTimeout);
        }
        Objects.requireNonNull(zkHost, "ZooKeeper host cannot be null!");
        if (this.solrClients.containsKey(zkHost)) {
            client = (CloudSolrClient)this.solrClients.get(zkHost);
        } else {
            String zkHostNoChroot = zkHost.split("/")[0];
            boolean canUseACLs = Optional.ofNullable(this.defaultZkHost.get()).map(zkHostNoChroot::equals).orElse(false);
            ArrayList<String> hosts = new ArrayList<String>();
            hosts.add(zkHost);
            CloudSolrClient.Builder builder = ((CloudSolrClient.Builder)((CloudSolrClient.Builder)new CloudSolrClient.Builder(hosts, Optional.empty()).withSocketTimeout(socketTimeout)).withConnectionTimeout(conTimeout)).canUseZkACLs(canUseACLs);
            if (this.httpClient != null) {
                builder = (CloudSolrClient.Builder)builder.withHttpClient(this.httpClient);
            }
            client = builder.build();
            this.solrClients.put(zkHost, client);
            client.connect();
        }
        return client;
    }

    public synchronized HttpSolrClient getHttpSolrClient(String host) {
        HttpSolrClient client;
        if (this.solrClients.containsKey(host)) {
            client = (HttpSolrClient)this.solrClients.get(host);
        } else {
            HttpSolrClient.Builder builder = (HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(host).withSocketTimeout(socketTimeout)).withConnectionTimeout(conTimeout);
            if (this.httpClient != null) {
                builder = (HttpSolrClient.Builder)builder.withHttpClient(this.httpClient);
            }
            client = builder.build();
            this.solrClients.put(host, client);
        }
        return client;
    }

    public synchronized void close() {
        for (Map.Entry<String, SolrClient> entry : this.solrClients.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                log.error("Error closing SolrClient for {}", (Object)entry.getKey(), (Object)e);
            }
        }
        this.solrClients.clear();
    }
}

