/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.credentialapi;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;

public class CredentialReader {
    public static String getDecryptedString(String CrendentialProviderPath, String alias, String storeType) {
        String credential = null;
        try {
            if (CrendentialProviderPath == null || alias == null) {
                return null;
            }
            char[] pass = null;
            Configuration conf = new Configuration();
            String crendentialProviderPrefixJceks = "jceks://file";
            String crendentialProviderPrefixLocalJceks = "localjceks://file";
            crendentialProviderPrefixJceks = crendentialProviderPrefixJceks.toLowerCase();
            String crendentialProviderPrefixBcfks = "bcfks://file";
            String crendentialProviderPrefixLocalBcfks = "localbcfks://file";
            crendentialProviderPrefixBcfks = crendentialProviderPrefixBcfks.toLowerCase();
            crendentialProviderPrefixLocalBcfks = crendentialProviderPrefixLocalBcfks.toLowerCase();
            CrendentialProviderPath = CrendentialProviderPath.trim();
            alias = alias.trim();
            if (CrendentialProviderPath.toLowerCase().startsWith(crendentialProviderPrefixJceks) || CrendentialProviderPath.toLowerCase().startsWith(crendentialProviderPrefixLocalJceks) || CrendentialProviderPath.toLowerCase().startsWith(crendentialProviderPrefixBcfks) || CrendentialProviderPath.toLowerCase().startsWith(crendentialProviderPrefixLocalBcfks)) {
                conf.set("hadoop.security.credential.provider.path", CrendentialProviderPath);
            } else if (CrendentialProviderPath.startsWith("/")) {
                if (StringUtils.equalsIgnoreCase((CharSequence)storeType, (CharSequence)"bcfks")) {
                    conf.set("hadoop.security.credential.provider.path", CrendentialProviderPath);
                } else {
                    conf.set("hadoop.security.credential.provider.path", "jceks://file" + CrendentialProviderPath);
                }
            } else {
                conf.set("hadoop.security.credential.provider.path", "jceks://file/" + CrendentialProviderPath);
            }
            List providers = CredentialProviderFactory.getProviders((Configuration)conf);
            List aliasesList = new ArrayList();
            CredentialProvider.CredentialEntry credEntry = null;
            for (CredentialProvider provider : providers) {
                aliasesList = provider.getAliases();
                if (aliasesList == null || !aliasesList.contains(alias.toLowerCase())) continue;
                credEntry = null;
                credEntry = provider.getCredentialEntry(alias.toLowerCase());
                pass = credEntry.getCredential();
                if (pass == null || pass.length <= 0) continue;
                credential = String.valueOf(pass);
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            credential = null;
        }
        return credential;
    }
}

