/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;

public class RangerAccessResourceReadOnly
implements RangerAccessResource {
    private final RangerAccessResource source;
    private final Set<String> keys;
    private final Map<String, Object> map;

    public RangerAccessResourceReadOnly(RangerAccessResource source) {
        this.source = source;
        Set<String> sourceKeys = source.getKeys();
        if (CollectionUtils.isEmpty(sourceKeys)) {
            sourceKeys = new HashSet<String>();
        }
        this.keys = Collections.unmodifiableSet(sourceKeys);
        Map<String, Object> sourceMap = source.getAsMap();
        if (MapUtils.isEmpty(sourceMap)) {
            sourceMap = new HashMap<String, Object>();
        }
        this.map = Collections.unmodifiableMap(sourceMap);
    }

    @Override
    public String getOwnerUser() {
        return this.source.getOwnerUser();
    }

    @Override
    public boolean exists(String name) {
        return this.source.exists(name);
    }

    @Override
    public Object getValue(String name) {
        return this.source.getValue(name);
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.source.getServiceDef();
    }

    @Override
    public Set<String> getKeys() {
        return this.keys;
    }

    @Override
    public String getLeafName() {
        return this.source.getLeafName();
    }

    @Override
    public String getAsString() {
        return this.source.getAsString();
    }

    @Override
    public String getCacheKey() {
        return this.source.getCacheKey();
    }

    @Override
    public Map<String, Object> getAsMap() {
        return this.map;
    }

    @Override
    public RangerAccessResource getReadOnlyCopy() {
        return this;
    }
}

