/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop;

import java.net.InetAddress;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.ipc.Server;
import org.apache.ranger.authorization.hadoop.RangerHdfsPlugin;
import org.apache.ranger.authorization.hadoop.RangerHdfsResource;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;

class RangerHdfsAccessRequest
extends RangerAccessRequestImpl {
    public RangerHdfsAccessRequest(INode inode, String path, String pathOwner, FsAction access, String accessType, String action, String user, Set<String> groups) {
        if (action == null && access != null) {
            action = access.toString();
        }
        super.setResource((RangerAccessResource)new RangerHdfsResource(path, pathOwner));
        super.setAccessType(accessType);
        super.setUser(user);
        super.setUserGroups(groups);
        super.setAccessTime(new Date());
        super.setClientIPAddress(RangerHdfsAccessRequest.getRemoteIp());
        super.setAction(action);
        super.setForwardedAddresses(null);
        super.setRemoteIPAddress(RangerHdfsAccessRequest.getRemoteIp());
        if (inode != null) {
            this.buildRequestContext(inode);
        }
    }

    private static String getRemoteIp() {
        String ret = null;
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            ret = ip.getHostAddress();
        }
        return ret;
    }

    private void buildRequestContext(INode inode) {
        if (inode.isFile()) {
            String fileName = inode.getLocalName();
            RangerAccessRequestUtil.setTokenInContext((Map)this.getContext(), (String)"FILENAME", (Object)fileName);
            int lastExtensionSeparatorIndex = fileName.lastIndexOf(RangerHdfsPlugin.getFileNameExtensionSeparator());
            if (lastExtensionSeparatorIndex != -1) {
                String baseFileName = fileName.substring(0, lastExtensionSeparatorIndex);
                RangerAccessRequestUtil.setTokenInContext((Map)this.getContext(), (String)"BASE_FILENAME", (Object)baseFileName);
            }
        }
    }
}

