/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.admin;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.configuration2.Configuration;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.admin.DistributedLogAdmin;
import org.apache.distributedlog.api.AsyncLogReader;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.logsegment.LogSegmentMetadataStore;
import org.apache.distributedlog.metadata.DryrunLogSegmentMetadataStoreUpdater;
import org.apache.distributedlog.metadata.LogSegmentMetadataStoreUpdater;
import org.apache.distributedlog.metadata.MetadataUpdater;
import org.apache.distributedlog.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDistributedLogAdmin
extends TestDistributedLogBase {
    static final Logger LOG = LoggerFactory.getLogger(TestDistributedLogAdmin.class);
    private ZooKeeperClient zooKeeperClient;

    @Override
    @Before
    public void setup() throws Exception {
        this.zooKeeperClient = TestZooKeeperClientBuilder.newBuilder().uri(this.createDLMURI("/")).build();
        conf.setTraceReadAheadMetadataChanges(true);
    }

    @Override
    @After
    public void teardown() throws Exception {
        this.zooKeeperClient.close();
    }

    public void testChangeSequenceNumber() throws Exception {
        LogRecordWithDLSN record;
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)conf);
        confLocal.setLogSegmentSequenceNumberValidationEnabled(false);
        confLocal.setLogSegmentCacheEnabled(false);
        DistributedLogConfiguration readConf = new DistributedLogConfiguration();
        readConf.addConfiguration((Configuration)conf);
        readConf.setLogSegmentCacheEnabled(false);
        readConf.setLogSegmentSequenceNumberValidationEnabled(true);
        URI uri = this.createDLMURI("/change-sequence-number");
        this.zooKeeperClient.get().create(uri.getPath(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Namespace namespace = NamespaceBuilder.newBuilder().conf(confLocal).uri(uri).build();
        Namespace readNamespace = NamespaceBuilder.newBuilder().conf(readConf).uri(uri).build();
        String streamName = "change-sequence-number";
        DistributedLogManager dlm = namespace.openLog(streamName);
        DLMTestUtil.generateCompletedLogSegments(dlm, confLocal, 4L, 10L);
        DLMTestUtil.injectLogSegmentWithGivenLogSegmentSeqNo(dlm, confLocal, 5L, 41L, false, 10L, true);
        dlm.close();
        DistributedLogManager readDLM = readNamespace.openLog(streamName);
        AsyncLogReader reader = readDLM.getAsyncLogReader(DLSN.InitialDLSN);
        long expectedTxId = 1L;
        DLSN lastDLSN = DLSN.InitialDLSN;
        for (int i = 0; i < 40; ++i) {
            record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader.readNext());
            Assert.assertNotNull((Object)record);
            DLMTestUtil.verifyLogRecord((LogRecord)record);
            Assert.assertEquals((long)expectedTxId, (long)record.getTransactionId());
            ++expectedTxId;
            lastDLSN = record.getDlsn();
        }
        LOG.info("Injecting bad log segment '3'");
        dlm = namespace.openLog(streamName);
        DLMTestUtil.injectLogSegmentWithGivenLogSegmentSeqNo(dlm, confLocal, 3L, 51L, true, 10L, false);
        LOG.info("Injected bad log segment '3'");
        CompletableFuture readFuture = reader.readNext();
        try {
            record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)readFuture);
            Assert.fail((String)("Should fail reading next record " + record + " when there is a corrupted log segment"));
        }
        catch (UnexpectedException record2) {
            // empty catch block
        }
        LOG.info("Dryrun fix inprogress segment that has lower sequence number");
        DistributedLogAdmin.fixInprogressSegmentWithLowerSequenceNumber((Namespace)namespace, (MetadataUpdater)new DryrunLogSegmentMetadataStoreUpdater(confLocal, this.getLogSegmentMetadataStore(namespace)), (String)streamName, (boolean)false, (boolean)false);
        try {
            reader = readDLM.getAsyncLogReader(lastDLSN);
            Utils.ioResult((CompletableFuture)reader.readNext());
            Assert.fail((String)"Should fail reading next when there is a corrupted log segment");
        }
        catch (UnexpectedException record2) {
            // empty catch block
        }
        LOG.info("Actual run fix inprogress segment that has lower sequence number");
        DistributedLogAdmin.fixInprogressSegmentWithLowerSequenceNumber((Namespace)namespace, (MetadataUpdater)LogSegmentMetadataStoreUpdater.createMetadataUpdater((DistributedLogConfiguration)confLocal, (LogSegmentMetadataStore)this.getLogSegmentMetadataStore(namespace)), (String)streamName, (boolean)false, (boolean)false);
        reader = readDLM.getAsyncLogReader(lastDLSN);
        Utils.ioResult((CompletableFuture)reader.readNext());
        readFuture = reader.readNext();
        expectedTxId = 51L;
        record = (LogRecord)Utils.ioResult((CompletableFuture)readFuture);
        Assert.assertNotNull((Object)record);
        DLMTestUtil.verifyLogRecord((LogRecord)record);
        Assert.assertEquals((long)expectedTxId, (long)record.getTransactionId());
        ++expectedTxId;
        for (int i = 1; i < 10; ++i) {
            record = (LogRecord)Utils.ioResult((CompletableFuture)reader.readNext());
            Assert.assertNotNull((Object)record);
            DLMTestUtil.verifyLogRecord((LogRecord)record);
            Assert.assertEquals((long)expectedTxId, (long)record.getTransactionId());
            ++expectedTxId;
        }
        Utils.close((AsyncCloseable)reader);
        readDLM.close();
        dlm.close();
        namespace.close();
        readNamespace.close();
    }
}

