/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.shard;

import lombok.Generated;
import lombok.NonNull;

public class NoShardAvailableException
extends RuntimeException {
    private final String key;
    private final Long shardId;

    public NoShardAvailableException(@NonNull String key) {
        super("No shard available to accept to key: " + key);
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.shardId = null;
    }

    public NoShardAvailableException(long shardId) {
        super("Shard not available : " + shardId);
        this.shardId = shardId;
        this.key = null;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Long getShardId() {
        return this.shardId;
    }
}

