/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.batch;

import io.opentelemetry.api.common.Attributes;
import io.oxia.client.ClientConfig;
import io.oxia.client.batch.Batch;
import io.oxia.client.batch.BatchFactory;
import io.oxia.client.batch.ReadBatch;
import io.oxia.client.grpc.OxiaStubProvider;
import io.oxia.client.metrics.InstrumentProvider;
import io.oxia.client.metrics.LatencyHistogram;
import lombok.Generated;
import lombok.NonNull;

class ReadBatchFactory
extends BatchFactory {
    private final LatencyHistogram readRequestLatencyHistogram;

    public ReadBatchFactory(@NonNull OxiaStubProvider stubProvider, @NonNull ClientConfig config, @NonNull InstrumentProvider instrumentProvider) {
        super(stubProvider, config);
        if (stubProvider == null) {
            throw new NullPointerException("stubProvider is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (instrumentProvider == null) {
            throw new NullPointerException("instrumentProvider is marked non-null but is null");
        }
        this.readRequestLatencyHistogram = instrumentProvider.newLatencyHistogram("oxia.client.ops.req", "The latency of a get batch request to the server", Attributes.builder().put("oxia.batch.type", "read").build());
    }

    @Override
    public Batch getBatch(long shardId) {
        return new ReadBatch(this, this.stubProvider, shardId);
    }

    @Generated
    public LatencyHistogram getReadRequestLatencyHistogram() {
        return this.readRequestLatencyHistogram;
    }
}

