/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.util.MultiChildLoadBalancer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nonnull;

@Internal
public class RoundRobinLoadBalancer
extends MultiChildLoadBalancer {
    private final Random random;
    protected RoundRobinPicker currentPicker = new EmptyPicker(EMPTY_OK);
    private static final Status EMPTY_OK = Status.OK.withDescription("no subchannels ready");

    public RoundRobinLoadBalancer(LoadBalancer.Helper helper) {
        super(helper);
        this.random = new Random();
    }

    @Override
    protected LoadBalancer.SubchannelPicker getSubchannelPicker(Map<Object, LoadBalancer.SubchannelPicker> childPickers) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void updateOverallBalancingState() {
        List<MultiChildLoadBalancer.ChildLbState> activeList = this.getReadyChildren();
        if (activeList.isEmpty()) {
            boolean isConnecting = false;
            for (MultiChildLoadBalancer.ChildLbState childLbState : this.getChildLbStates()) {
                ConnectivityState state = childLbState.getCurrentState();
                if (state != ConnectivityState.CONNECTING && state != ConnectivityState.IDLE) continue;
                isConnecting = true;
                break;
            }
            if (isConnecting) {
                this.updateBalancingState(ConnectivityState.CONNECTING, new EmptyPicker(Status.OK));
            } else {
                this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, this.createReadyPicker(this.getChildLbStates()));
            }
        } else {
            this.updateBalancingState(ConnectivityState.READY, this.createReadyPicker(activeList));
        }
    }

    private void updateBalancingState(ConnectivityState state, RoundRobinPicker picker) {
        if (state != this.currentConnectivityState || !picker.isEquivalentTo(this.currentPicker)) {
            this.getHelper().updateBalancingState(state, (LoadBalancer.SubchannelPicker)picker);
            this.currentConnectivityState = state;
            this.currentPicker = picker;
        }
    }

    protected RoundRobinPicker createReadyPicker(Collection<MultiChildLoadBalancer.ChildLbState> children) {
        int startIndex = this.random.nextInt(children.size());
        ArrayList<LoadBalancer.SubchannelPicker> pickerList = new ArrayList<LoadBalancer.SubchannelPicker>();
        for (MultiChildLoadBalancer.ChildLbState child : children) {
            LoadBalancer.SubchannelPicker picker = child.getCurrentPicker();
            pickerList.add(picker);
        }
        return new ReadyPicker(pickerList, startIndex);
    }

    @VisibleForTesting
    static final class Ref<T> {
        T value;

        Ref(T value) {
            this.value = value;
        }
    }

    @VisibleForTesting
    static final class EmptyPicker
    extends RoundRobinPicker {
        private final Status status;

        EmptyPicker(@Nonnull Status status) {
            this.status = (Status)Preconditions.checkNotNull((Object)status, (Object)"status");
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return this.status.isOk() ? LoadBalancer.PickResult.withNoResult() : LoadBalancer.PickResult.withError((Status)this.status);
        }

        @Override
        public boolean isEquivalentTo(RoundRobinPicker picker) {
            return picker instanceof EmptyPicker && (Objects.equal((Object)this.status, (Object)((EmptyPicker)picker).status) || this.status.isOk() && ((EmptyPicker)picker).status.isOk());
        }

        public String toString() {
            return MoreObjects.toStringHelper(EmptyPicker.class).add("status", (Object)this.status).toString();
        }
    }

    @VisibleForTesting
    static class ReadyPicker
    extends RoundRobinPicker {
        private static final AtomicIntegerFieldUpdater<ReadyPicker> indexUpdater = AtomicIntegerFieldUpdater.newUpdater(ReadyPicker.class, "index");
        private final List<LoadBalancer.SubchannelPicker> subchannelPickers;
        private volatile int index;

        public ReadyPicker(List<LoadBalancer.SubchannelPicker> list, int startIndex) {
            Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"empty list");
            this.subchannelPickers = list;
            this.index = startIndex - 1;
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return this.subchannelPickers.get(this.nextIndex()).pickSubchannel(args);
        }

        public String toString() {
            return MoreObjects.toStringHelper(ReadyPicker.class).add("subchannelPickers", this.subchannelPickers).toString();
        }

        private int nextIndex() {
            int size = this.subchannelPickers.size();
            int i = indexUpdater.incrementAndGet(this);
            if (i >= size) {
                int oldi = i;
                indexUpdater.compareAndSet(this, oldi, i %= size);
            }
            return i;
        }

        @VisibleForTesting
        List<LoadBalancer.SubchannelPicker> getSubchannelPickers() {
            return this.subchannelPickers;
        }

        @Override
        public boolean isEquivalentTo(RoundRobinPicker picker) {
            if (!(picker instanceof ReadyPicker)) {
                return false;
            }
            ReadyPicker other = (ReadyPicker)picker;
            return other == this || this.subchannelPickers.size() == other.subchannelPickers.size() && new HashSet<LoadBalancer.SubchannelPicker>(this.subchannelPickers).containsAll(other.subchannelPickers);
        }
    }

    public static abstract class RoundRobinPicker
    extends LoadBalancer.SubchannelPicker {
        public abstract boolean isEquivalentTo(RoundRobinPicker var1);
    }
}

