/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.client;

import com.beust.jcommander.Parameter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.api.BookKeeper;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.tools.cli.helpers.ClientCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTestCommand
extends ClientCommand<Flags> {
    private static final String NAME = "simpletest";
    private static final String DESC = "Simple test to create a ledger and write entries to it, then read it.";
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTestCommand.class);

    public SimpleTestCommand() {
        this(Flags.newFlags());
    }

    public SimpleTestCommand(Flags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)flags).build());
    }

    @VisibleForTesting
    public static SimpleTestCommand newSimpleTestCommand(Flags flags) {
        return new SimpleTestCommand(flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE", "DMI_RANDOM_USED_ONLY_ONCE"})
    protected void run(BookKeeper bk, Flags flags) throws Exception {
        block21: {
            byte[] data = new byte[100];
            Random random = new Random(0L);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(random.nextInt(26) + 65);
            }
            long ledgerId = -1L;
            long lastEntryId = -1L;
            try (WriteHandle wh = (WriteHandle)FutureUtils.result(bk.newCreateLedgerOp().withEnsembleSize(flags.ensembleSize).withWriteQuorumSize(flags.writeQuorumSize).withAckQuorumSize(flags.ackQuorumSize).withDigestType(DigestType.CRC32C).withCustomMetadata((Map<String, byte[]>)ImmutableMap.of((Object)"Bookie", (Object)NAME.getBytes(StandardCharsets.UTF_8))).withPassword(new byte[0]).execute());){
                ledgerId = wh.getId();
                LOG.info("Ledger ID: {}", (Object)ledgerId);
                long lastReport = System.nanoTime();
                for (int i = 0; i < flags.numEntries; ++i) {
                    wh.append(data);
                    if (TimeUnit.SECONDS.convert(System.nanoTime() - lastReport, TimeUnit.NANOSECONDS) <= 1L) continue;
                    LOG.info("{} entries written", (Object)i);
                    lastReport = System.nanoTime();
                }
                lastEntryId = wh.getLastAddPushed();
                LOG.info("{} entries written to ledger {}. Last entry Id {}", new Object[]{flags.numEntries, ledgerId, lastEntryId});
                if (lastEntryId != (long)(flags.numEntries - 1)) {
                    throw new IllegalStateException("Last entry id doesn't match the expected value");
                }
                SimpleTestCommand.readEntries(bk, ledgerId, lastEntryId, flags.numEntries, true, data);
            }
            if (ledgerId != -1L) {
                try {
                    if (lastEntryId != -1L) {
                        SimpleTestCommand.readEntries(bk, ledgerId, lastEntryId, flags.numEntries, false, data);
                        break block21;
                    }
                    throw new IllegalStateException("Last entry id is not set");
                }
                finally {
                    FutureUtils.result(bk.newDeleteLedgerOp().withLedgerId(ledgerId).execute());
                }
            }
            throw new IllegalStateException("Ledger id is not set");
        }
    }

    private static void readEntries(BookKeeper bk, long ledgerId, long lastEntryId, int expectedNumberOfEntries, boolean readUnconfirmed, byte[] data) throws Exception {
        int entriesRead = 0;
        try (ReadHandle rh = (ReadHandle)FutureUtils.result(bk.newOpenLedgerOp().withLedgerId(ledgerId).withDigestType(DigestType.CRC32C).withPassword(new byte[0]).execute());
             LedgerEntries ledgerEntries = readUnconfirmed ? rh.readUnconfirmed(0L, lastEntryId) : rh.read(0L, lastEntryId);){
            for (LedgerEntry ledgerEntry : ledgerEntries) {
                if (!Arrays.equals(ledgerEntry.getEntryBytes(), data)) {
                    throw new IllegalStateException("Read data doesn't match the data written.");
                }
                ++entriesRead;
            }
        }
        if (entriesRead != expectedNumberOfEntries) {
            throw new IllegalStateException(String.format("Number of entries read (%d) doesn't match the expected value (%d).", entriesRead, expectedNumberOfEntries));
        }
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-e", "--ensemble-size"}, description="Ensemble size (default 3)")
        private int ensembleSize = 3;
        @Parameter(names={"-w", "--write-quorum-size"}, description="Write quorum size (default 2)")
        private int writeQuorumSize = 2;
        @Parameter(names={"-a", "--ack-quorum-size"}, description="Ack quorum size (default 2)")
        private int ackQuorumSize = 2;
        @Parameter(names={"-n", "--num-entries"}, description="Entries to write (default 100)")
        private int numEntries = 100;

        @VisibleForTesting
        public static Flags newFlags() {
            return new Flags();
        }

        public Flags ensembleSize(int ensembleSize) {
            this.ensembleSize = ensembleSize;
            return this;
        }

        public Flags writeQuorumSize(int writeQuorumSize) {
            this.writeQuorumSize = writeQuorumSize;
            return this;
        }

        public Flags ackQuorumSize(int ackQuorumSize) {
            this.ackQuorumSize = ackQuorumSize;
            return this;
        }

        public Flags numEntries(int numEntries) {
            this.numEntries = numEntries;
            return this;
        }
    }
}

