/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import io.netty.util.Recycler;
import org.apache.bookkeeper.bookie.storage.ldb.ArrayUtil;

class LongWrapper {
    final byte[] array = new byte[8];
    private static final Recycler<LongWrapper> RECYCLER = new Recycler<LongWrapper>(){

        protected LongWrapper newObject(Recycler.Handle<LongWrapper> handle) {
            return new LongWrapper(handle);
        }
    };
    private final Recycler.Handle<LongWrapper> handle;

    public void set(long value) {
        ArrayUtil.setLong(this.array, 0, value);
    }

    public long getValue() {
        return ArrayUtil.getLong(this.array, 0);
    }

    public static LongWrapper get() {
        return (LongWrapper)RECYCLER.get();
    }

    public static LongWrapper get(long value) {
        LongWrapper lp = (LongWrapper)RECYCLER.get();
        ArrayUtil.setLong(lp.array, 0, value);
        return lp;
    }

    public void recycle() {
        this.handle.recycle((Object)this);
    }

    private LongWrapper(Recycler.Handle<LongWrapper> handle) {
        this.handle = handle;
    }
}

