/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.api.kv.impl.op;

import com.google.common.collect.Lists;
import io.netty.util.Recycler;
import java.util.List;
import org.apache.bookkeeper.api.kv.impl.op.TxnOpImpl;
import org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.bookkeeper.api.kv.op.Op;
import org.apache.bookkeeper.api.kv.op.TxnOp;
import org.apache.bookkeeper.api.kv.op.TxnOpBuilder;

class TxnOpBuilderImpl<K, V>
implements TxnOpBuilder<K, V> {
    private final Recycler.Handle<TxnOpBuilderImpl<K, V>> handle;
    private final Recycler<TxnOpImpl<K, V>> txnOpRecycler;
    private List<CompareOp<K, V>> compareOps;
    private List<Op<K, V>> successOps;
    private List<Op<K, V>> failureOps;

    TxnOpBuilderImpl(Recycler.Handle<TxnOpBuilderImpl<K, V>> handle, Recycler<TxnOpImpl<K, V>> txnOpRecycler) {
        this.handle = handle;
        this.txnOpRecycler = txnOpRecycler;
    }

    @Override
    public synchronized TxnOpBuilder<K, V> If(CompareOp ... cmps) {
        if (null == this.compareOps) {
            this.compareOps = Lists.newArrayList();
        }
        for (CompareOp cmp : cmps) {
            this.compareOps.add(cmp);
        }
        return this;
    }

    @Override
    public synchronized TxnOpBuilder<K, V> Then(Op ... ops) {
        if (null == this.successOps) {
            this.successOps = Lists.newArrayList();
        }
        for (Op op : ops) {
            this.successOps.add(op);
        }
        return this;
    }

    @Override
    public synchronized TxnOpBuilder<K, V> Else(Op ... ops) {
        if (null == this.failureOps) {
            this.failureOps = Lists.newArrayList();
        }
        for (Op op : ops) {
            this.failureOps.add(op);
        }
        return this;
    }

    @Override
    public synchronized TxnOp<K, V> build() {
        try {
            TxnOpImpl<K, V> txnOpImpl = ((TxnOpImpl)this.txnOpRecycler.get()).compareOps(this.compareOps).successOps(this.successOps).failureOps(this.failureOps);
            return txnOpImpl;
        }
        finally {
            this.compareOps = null;
            this.successOps = null;
            this.failureOps = null;
            this.handle.recycle((Object)this);
        }
    }
}

