/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.io.IOException;
import java.util.List;
import org.apache.distributedlog.BKAbstractLogWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogSegmentWriter;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.api.LogWriter;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.util.Utils;

class BKSyncLogWriter
extends BKAbstractLogWriter
implements LogWriter {
    public BKSyncLogWriter(DistributedLogConfiguration conf, DynamicDistributedLogConfiguration dynConf, BKDistributedLogManager bkdlm) {
        super(conf, dynConf, bkdlm);
    }

    @Override
    public void write(LogRecord record) throws IOException {
        this.getLedgerWriter(record.getTransactionId(), false).write(record);
    }

    @Override
    @Deprecated
    public int writeBulk(List<LogRecord> records) throws IOException {
        return this.getLedgerWriter(records.get(0).getTransactionId(), false).writeBulk(records);
    }

    @Override
    public void markEndOfStream() throws IOException {
        Utils.ioResult(this.getLedgerWriter(Long.MAX_VALUE, true).markEndOfStream());
        this.closeAndComplete();
    }

    @Override
    public long flush() throws IOException {
        this.checkClosedOrInError("flush");
        long highestTransactionId = 0L;
        BKLogSegmentWriter writer = this.getCachedLogWriter();
        if (null != writer) {
            highestTransactionId = Math.max(highestTransactionId, Utils.ioResult(writer.flush()));
        }
        return highestTransactionId;
    }

    @Override
    public long commit() throws IOException {
        this.checkClosedOrInError("commit");
        if (LOG.isDebugEnabled()) {
            LOG.debug("FlushAndSync Started");
        }
        long highestTransactionId = 0L;
        BKLogSegmentWriter writer = this.getCachedLogWriter();
        if (null != writer) {
            highestTransactionId = Math.max(highestTransactionId, Utils.ioResult(writer.commit()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("FlushAndSync Completed");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("FlushAndSync Completed - Nothing to Flush");
        }
        return highestTransactionId;
    }

    @Override
    public void abort() throws IOException {
        super.abort();
    }
}

