/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendOnlyStreamWriter
implements Closeable {
    static final Logger LOG = LoggerFactory.getLogger(AppendOnlyStreamWriter.class);
    final long[] syncPos = new long[1];
    BKAsyncLogWriter logWriter;
    long requestPos = 0L;

    public AppendOnlyStreamWriter(BKAsyncLogWriter logWriter, long pos) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialize at position {}", (Object)pos);
        }
        this.logWriter = logWriter;
        this.syncPos[0] = pos;
        this.requestPos = pos;
    }

    public CompletableFuture<DLSN> write(byte[] data) {
        this.requestPos += (long)data.length;
        CompletableFuture<DLSN> writeResult = this.logWriter.write(new LogRecord(this.requestPos, data));
        return writeResult.whenComplete((BiConsumer)((Object)new WriteCompleteListener(this.requestPos)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void force(boolean metadata) throws IOException {
        long pos = 0L;
        try {
            pos = (Long)FutureUtils.result(this.logWriter.flushAndCommit());
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            LOG.error("unexpected exception in AppendOnlyStreamWriter.force ", (Throwable)ex);
            throw new UnexpectedException("unexpected exception in AppendOnlyStreamWriter.force", (Throwable)ex);
        }
        long[] lArray = this.syncPos;
        synchronized (this.syncPos) {
            this.syncPos[0] = pos;
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position() {
        long[] lArray = this.syncPos;
        synchronized (this.syncPos) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.syncPos[0];
        }
    }

    @Override
    public void close() throws IOException {
        this.logWriter.closeAndComplete();
    }

    public void markEndOfStream() throws IOException {
        try {
            FutureUtils.result(this.logWriter.markEndOfStream());
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            throw new UnexpectedException("Mark end of stream hit unexpected exception", (Throwable)ex);
        }
    }

    class WriteCompleteListener
    implements FutureEventListener<DLSN> {
        private final long position;

        public WriteCompleteListener(long position) {
            this.position = position;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(DLSN response) {
            long[] lArray = AppendOnlyStreamWriter.this.syncPos;
            synchronized (AppendOnlyStreamWriter.this.syncPos) {
                if (this.position > AppendOnlyStreamWriter.this.syncPos[0]) {
                    AppendOnlyStreamWriter.this.syncPos[0] = this.position;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void onFailure(Throwable cause) {
        }
    }
}

