/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MaxRequestSizeFilter
implements Filter {
    private final long maxSize;

    public MaxRequestSizeFilter(long maxSize) {
        this.maxSize = maxSize;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long size = request.getContentLengthLong();
        if (size > this.maxSize || MaxRequestSizeFilter.isChunked(request)) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(400, "Bad Request");
        } else {
            chain.doFilter(request, response);
        }
    }

    private static boolean isChunked(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            String encoding = req.getHeader("Transfer-Encoding");
            return encoding != null && encoding.contains("chunked");
        }
        return false;
    }

    public void destroy() {
    }
}

