/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import io.netty.util.HashedWheelTimer;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.transaction.buffer.TransactionBufferClientStats;
import org.apache.pulsar.broker.transaction.buffer.impl.TransactionBufferHandlerImpl;
import org.apache.pulsar.client.api.transaction.TransactionBufferClient;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.transaction.TransactionBufferHandler;
import org.apache.pulsar.common.api.proto.TxnAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBufferClientImpl
implements TransactionBufferClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionBufferClientImpl.class);
    private final TransactionBufferHandler tbHandler;
    private final TransactionBufferClientStats stats;

    private TransactionBufferClientImpl(PulsarService pulsarService, TransactionBufferHandler tbHandler, boolean exposeTopicLevelMetrics, boolean enableTxnCoordinator) {
        this.tbHandler = tbHandler;
        this.stats = TransactionBufferClientStats.create(pulsarService, exposeTopicLevelMetrics, tbHandler, enableTxnCoordinator);
    }

    public static TransactionBufferClient create(PulsarService pulsarService, HashedWheelTimer timer, int maxConcurrentRequests, long operationTimeoutInMills) throws PulsarServerException {
        TransactionBufferHandlerImpl handler = new TransactionBufferHandlerImpl(pulsarService, timer, maxConcurrentRequests, operationTimeoutInMills);
        ServiceConfiguration config = pulsarService.getConfig();
        boolean exposeTopicLevelMetrics = config.isExposeTopicLevelMetricsInPrometheus();
        boolean enableTxnCoordinator = config.isTransactionCoordinatorEnabled();
        return new TransactionBufferClientImpl(pulsarService, handler, exposeTopicLevelMetrics, enableTxnCoordinator);
    }

    public CompletableFuture<TxnID> commitTxnOnTopic(String topic, long txnIdMostBits, long txnIdLeastBits, long lowWaterMark) {
        long start = System.nanoTime();
        return this.tbHandler.endTxnOnTopic(topic, txnIdMostBits, txnIdLeastBits, TxnAction.COMMIT, lowWaterMark).whenComplete((__, t) -> {
            if (null != t) {
                this.stats.recordCommitFailed(topic);
            } else {
                this.stats.recordCommitLatency(topic, System.nanoTime() - start);
            }
        });
    }

    public CompletableFuture<TxnID> abortTxnOnTopic(String topic, long txnIdMostBits, long txnIdLeastBits, long lowWaterMark) {
        long start = System.nanoTime();
        return this.tbHandler.endTxnOnTopic(topic, txnIdMostBits, txnIdLeastBits, TxnAction.ABORT, lowWaterMark).whenComplete((__, t) -> {
            if (null != t) {
                this.stats.recordAbortFailed(topic);
            } else {
                this.stats.recordAbortLatency(topic, System.nanoTime() - start);
            }
        });
    }

    public CompletableFuture<TxnID> commitTxnOnSubscription(String topic, String subscription, long txnIdMostBits, long txnIdLeastBits, long lowWaterMark) {
        long start = System.nanoTime();
        return this.tbHandler.endTxnOnSubscription(topic, subscription, txnIdMostBits, txnIdLeastBits, TxnAction.COMMIT, lowWaterMark).whenComplete((__, t) -> {
            if (null != t) {
                this.stats.recordCommitFailed(topic);
            } else {
                this.stats.recordCommitLatency(topic, System.nanoTime() - start);
            }
        });
    }

    public CompletableFuture<TxnID> abortTxnOnSubscription(String topic, String subscription, long txnIdMostBits, long txnIdLeastBits, long lowWaterMark) {
        long start = System.nanoTime();
        return this.tbHandler.endTxnOnSubscription(topic, subscription, txnIdMostBits, txnIdLeastBits, TxnAction.ABORT, lowWaterMark).whenComplete((__, t) -> {
            if (null != t) {
                this.stats.recordAbortFailed(topic);
            } else {
                this.stats.recordAbortLatency(topic, System.nanoTime() - start);
            }
        });
    }

    public void close() {
        this.tbHandler.close();
        this.stats.close();
    }

    public int getAvailableRequestCredits() {
        return this.tbHandler.getAvailableRequestCredits();
    }

    public int getPendingRequestsCount() {
        return this.tbHandler.getPendingRequestsCount();
    }
}

