/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.TopicPolicyListener;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.common.events.PulsarEvent;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public interface TopicPoliciesService
extends AutoCloseable {
    public static final String GLOBAL_POLICIES_MSG_KEY_PREFIX = "__G__";
    public static final Logger LOG = LoggerFactory.getLogger(TopicPoliciesService.class);
    public static final TopicPoliciesService DISABLED = new TopicPoliciesServiceDisabled();

    public CompletableFuture<Void> deleteTopicPoliciesAsync(TopicName var1);

    default public CompletableFuture<Void> deleteTopicPoliciesAsync(TopicName topicName, boolean keepGlobalPoliciesAfterDeleting) {
        return this.deleteTopicPoliciesAsync(topicName);
    }

    public CompletableFuture<Void> updateTopicPoliciesAsync(TopicName var1, boolean var2, boolean var3, Consumer<TopicPolicies> var4);

    public CompletableFuture<Optional<TopicPolicies>> getTopicPoliciesAsync(TopicName var1, GetType var2);

    default public void start(PulsarService pulsar) {
    }

    @Override
    default public void close() throws Exception {
    }

    public boolean registerListener(TopicName var1, TopicPolicyListener var2);

    public void unregisterListener(TopicName var1, TopicPolicyListener var2);

    public static String getEventKey(PulsarEvent event, boolean isGlobal) {
        return TopicPoliciesService.wrapEventKey(TopicName.get((String)event.getTopicPoliciesEvent().getDomain(), (String)event.getTopicPoliciesEvent().getTenant(), (String)event.getTopicPoliciesEvent().getNamespace(), (String)event.getTopicPoliciesEvent().getTopic()).toString(), isGlobal);
    }

    public static String wrapEventKey(String originalKey, boolean isGlobalPolicies) {
        if (!isGlobalPolicies) {
            return originalKey;
        }
        return GLOBAL_POLICIES_MSG_KEY_PREFIX + originalKey;
    }

    public static boolean isGlobalPolicy(Message<PulsarEvent> msg) {
        return msg.getKey().startsWith(GLOBAL_POLICIES_MSG_KEY_PREFIX);
    }

    public static TopicName unwrapEventKey(String originalKey) {
        String tpName = originalKey;
        if (originalKey.startsWith(GLOBAL_POLICIES_MSG_KEY_PREFIX)) {
            tpName = originalKey.substring(GLOBAL_POLICIES_MSG_KEY_PREFIX.length());
        }
        return TopicName.get((String)tpName);
    }

    public static class TopicPoliciesServiceDisabled
    implements TopicPoliciesService {
        @Override
        public CompletableFuture<Void> deleteTopicPoliciesAsync(TopicName topicName) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> updateTopicPoliciesAsync(TopicName topicName, boolean isGlobalPolicy, boolean skipUpdateWhenTopicPolicyDoesntExist, Consumer<TopicPolicies> policyUpdater) {
            return FutureUtil.failedFuture((Throwable)new UnsupportedOperationException("Topic policies service is disabled."));
        }

        @Override
        public CompletableFuture<Optional<TopicPolicies>> getTopicPoliciesAsync(TopicName topicName, GetType type) {
            return CompletableFuture.completedFuture(Optional.empty());
        }

        @Override
        public boolean registerListener(TopicName topicName, TopicPolicyListener listener) {
            return false;
        }

        @Override
        public void unregisterListener(TopicName topicName, TopicPolicyListener listener) {
        }
    }

    public static enum GetType {
        GLOBAL_ONLY,
        LOCAL_ONLY;

    }
}

