/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.ConsumerHashAssignmentsSnapshot;
import org.apache.pulsar.broker.service.HashRangeAssignment;
import org.apache.pulsar.broker.service.ImpactedConsumersResult;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.client.api.Range;

public class HashRangeAutoSplitStickyKeyConsumerSelector
implements StickyKeyConsumerSelector {
    private final int rangeSize;
    private final Range keyHashRange;
    private final ConcurrentSkipListMap<Integer, Consumer> rangeMap;
    private final Map<Consumer, Integer> consumerRange;
    private final boolean addOrRemoveReturnsImpactedConsumersResult;
    private ConsumerHashAssignmentsSnapshot consumerHashAssignmentsSnapshot;

    public HashRangeAutoSplitStickyKeyConsumerSelector() {
        this(false);
    }

    public HashRangeAutoSplitStickyKeyConsumerSelector(boolean addOrRemoveReturnsImpactedConsumersResult) {
        this(65536, addOrRemoveReturnsImpactedConsumersResult);
    }

    public HashRangeAutoSplitStickyKeyConsumerSelector(int rangeSize, boolean addOrRemoveReturnsImpactedConsumersResult) {
        this.addOrRemoveReturnsImpactedConsumersResult = addOrRemoveReturnsImpactedConsumersResult;
        if (rangeSize < 2) {
            throw new IllegalArgumentException("range size must greater than 2");
        }
        if (!this.is2Power(rangeSize)) {
            throw new IllegalArgumentException("range size must be nth power with 2");
        }
        this.rangeMap = new ConcurrentSkipListMap();
        this.consumerRange = new HashMap<Consumer, Integer>();
        this.rangeSize = rangeSize;
        this.keyHashRange = Range.of((int)0, (int)(rangeSize - 1));
        this.consumerHashAssignmentsSnapshot = addOrRemoveReturnsImpactedConsumersResult ? ConsumerHashAssignmentsSnapshot.empty() : null;
    }

    @Override
    public synchronized CompletableFuture<Optional<ImpactedConsumersResult>> addConsumer(Consumer consumer) {
        if (this.rangeMap.isEmpty()) {
            this.rangeMap.put(this.rangeSize, consumer);
            this.consumerRange.put(consumer, this.rangeSize);
        } else {
            try {
                this.splitRange(this.findBiggestRange(), consumer);
            }
            catch (BrokerServiceException.ConsumerAssignException e) {
                return CompletableFuture.failedFuture(e);
            }
        }
        if (!this.addOrRemoveReturnsImpactedConsumersResult) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        ConsumerHashAssignmentsSnapshot assignmentsAfter = this.internalGetConsumerHashAssignmentsSnapshot();
        ImpactedConsumersResult impactedConsumers = this.consumerHashAssignmentsSnapshot.resolveImpactedConsumers(assignmentsAfter);
        this.consumerHashAssignmentsSnapshot = assignmentsAfter;
        return CompletableFuture.completedFuture(Optional.of(impactedConsumers));
    }

    @Override
    public synchronized Optional<ImpactedConsumersResult> removeConsumer(Consumer consumer) {
        Integer removeRange = this.consumerRange.remove(consumer);
        if (removeRange != null) {
            if (removeRange == this.rangeSize && this.rangeMap.size() > 1) {
                Map.Entry<Integer, Consumer> lowerEntry = this.rangeMap.lowerEntry(removeRange);
                this.rangeMap.put(removeRange, lowerEntry.getValue());
                this.rangeMap.remove(lowerEntry.getKey());
                this.consumerRange.put(lowerEntry.getValue(), removeRange);
            } else {
                this.rangeMap.remove(removeRange);
            }
        }
        if (!this.addOrRemoveReturnsImpactedConsumersResult) {
            return Optional.empty();
        }
        ConsumerHashAssignmentsSnapshot assignmentsAfter = this.internalGetConsumerHashAssignmentsSnapshot();
        ImpactedConsumersResult impactedConsumers = this.consumerHashAssignmentsSnapshot.resolveImpactedConsumers(assignmentsAfter);
        this.consumerHashAssignmentsSnapshot = assignmentsAfter;
        return Optional.of(impactedConsumers);
    }

    @Override
    public Consumer select(int hash) {
        if (!this.rangeMap.isEmpty()) {
            return this.rangeMap.ceilingEntry(hash).getValue();
        }
        return null;
    }

    @Override
    public Range getKeyHashRange() {
        return this.keyHashRange;
    }

    @Override
    public synchronized ConsumerHashAssignmentsSnapshot getConsumerHashAssignmentsSnapshot() {
        return this.consumerHashAssignmentsSnapshot != null ? this.consumerHashAssignmentsSnapshot : this.internalGetConsumerHashAssignmentsSnapshot();
    }

    private ConsumerHashAssignmentsSnapshot internalGetConsumerHashAssignmentsSnapshot() {
        ArrayList<HashRangeAssignment> result = new ArrayList<HashRangeAssignment>();
        int start = 0;
        for (Map.Entry<Integer, Consumer> entry : this.rangeMap.entrySet()) {
            result.add(new HashRangeAssignment(Range.of((int)start, (int)entry.getKey()), entry.getValue()));
            start = entry.getKey() + 1;
        }
        return ConsumerHashAssignmentsSnapshot.of(result);
    }

    private int findBiggestRange() {
        int slots = 0;
        int busiestRange = this.rangeSize;
        for (Map.Entry<Integer, Consumer> entry : this.rangeMap.entrySet()) {
            Integer lowerKey = this.rangeMap.lowerKey(entry.getKey());
            if (lowerKey == null) {
                lowerKey = 0;
            }
            if (entry.getKey() - lowerKey <= slots) continue;
            slots = entry.getKey() - lowerKey;
            busiestRange = entry.getKey();
        }
        return busiestRange;
    }

    private void splitRange(int range, Consumer targetConsumer) throws BrokerServiceException.ConsumerAssignException {
        Integer lowerKey = this.rangeMap.lowerKey(range);
        if (lowerKey == null) {
            lowerKey = 0;
        }
        if (range - lowerKey <= 1) {
            throw new BrokerServiceException.ConsumerAssignException("No more range can assigned to new consumer, assigned consumers " + this.rangeMap.size());
        }
        int splitRange = range - (range - lowerKey >> 1);
        this.rangeMap.put(splitRange, targetConsumer);
        this.consumerRange.put(targetConsumer, splitRange);
    }

    private boolean is2Power(int num) {
        if (num < 2) {
            return false;
        }
        return (num & num - 1) == 0;
    }
}

